/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.resourcepool;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.Queuable;
import com.mchange.v2.async.RoundRobinAsynchronousRunner;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.async.SimpleRunnableQueue;
import com.mchange.v2.resourcepool.BasicResourcePool;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;

class BasicResourcePoolFactory
extends ResourcePoolFactory {
    int start = -1;
    int min = 1;
    int max = 12;
    int inc = 3;
    int retry_attempts = -1;
    int retry_delay = 1000;
    long max_age = -1L;
    boolean age_is_absolute = true;
    AsynchronousRunner taskRunner;
    boolean taskRunner_is_external;
    RunnableQueue asyncEventQueue;
    boolean asyncEventQueue_is_external;
    Timer cullTimer;
    boolean cullTimer_is_external;
    int default_num_task_threads;
    Set liveChildren;

    BasicResourcePoolFactory() {
        this(null, null, null);
    }

    BasicResourcePoolFactory(AsynchronousRunner asynchronousRunner, RunnableQueue runnableQueue, Timer timer) {
        this(asynchronousRunner, runnableQueue, timer, 3);
    }

    BasicResourcePoolFactory(int n) {
        this(null, null, null, n);
    }

    BasicResourcePoolFactory(AsynchronousRunner asynchronousRunner, RunnableQueue runnableQueue, Timer timer, int n) {
        this.taskRunner = asynchronousRunner;
        this.taskRunner_is_external = asynchronousRunner != null;
        this.asyncEventQueue = runnableQueue;
        this.asyncEventQueue_is_external = runnableQueue != null;
        this.cullTimer = timer;
        this.cullTimer_is_external = timer != null;
        this.default_num_task_threads = n;
    }

    private void createThreadResources() {
        if (!this.taskRunner_is_external) {
            this.taskRunner = new RoundRobinAsynchronousRunner(this.default_num_task_threads, true);
            if (!this.asyncEventQueue_is_external) {
                this.asyncEventQueue = ((Queuable)this.taskRunner).asRunnableQueue();
            }
        }
        if (this.asyncEventQueue == null) {
            this.asyncEventQueue = new SimpleRunnableQueue(true);
        }
        if (!this.cullTimer_is_external) {
            this.cullTimer = new Timer(true);
        }
        this.liveChildren = new HashSet();
    }

    private void destroyThreadResources() {
        if (!this.taskRunner_is_external) {
            this.taskRunner.close();
            this.taskRunner = null;
        }
        if (!this.asyncEventQueue_is_external) {
            this.asyncEventQueue.close();
            this.asyncEventQueue = null;
        }
        if (this.cullTimer_is_external) {
            this.cullTimer.cancel();
            this.cullTimer = null;
        }
        this.liveChildren = null;
    }

    synchronized void markBroken(BasicResourcePool basicResourcePool) {
        this.liveChildren.remove(basicResourcePool);
        if (this.liveChildren.isEmpty()) {
            this.destroyThreadResources();
        }
    }

    public synchronized void setStart(int n) throws ResourcePoolException {
        this.start = n;
    }

    public synchronized int getStart() throws ResourcePoolException {
        return this.start;
    }

    public synchronized void setMin(int n) throws ResourcePoolException {
        this.min = n;
    }

    public synchronized int getMin() throws ResourcePoolException {
        return this.min;
    }

    public synchronized void setMax(int n) throws ResourcePoolException {
        this.max = n;
    }

    public synchronized int getMax() throws ResourcePoolException {
        return this.max;
    }

    public synchronized void setIncrement(int n) throws ResourcePoolException {
        this.inc = n;
    }

    public synchronized int getIncrement() throws ResourcePoolException {
        return this.inc;
    }

    public synchronized void setAcquisitionRetryAttempts(int n) throws ResourcePoolException {
        this.retry_attempts = n;
    }

    public synchronized int getAcquisitionRetryAttempts() throws ResourcePoolException {
        return this.retry_attempts;
    }

    public synchronized void setAcquisitionRetryDelay(int n) throws ResourcePoolException {
        this.retry_delay = n;
    }

    public synchronized int getAcquisitionRetryDelay() throws ResourcePoolException {
        return this.retry_delay;
    }

    public synchronized void setResourceMaxAge(long l) throws ResourcePoolException {
        this.max_age = l;
    }

    public synchronized long getResourceMaxAge() throws ResourcePoolException {
        return this.max_age;
    }

    public synchronized void setAgeIsAbsolute(boolean bl) throws ResourcePoolException {
        this.age_is_absolute = bl;
    }

    public synchronized boolean getAgeIsAbsolute() throws ResourcePoolException {
        return this.age_is_absolute;
    }

    public synchronized ResourcePool createPool(ResourcePool.Manager manager) throws ResourcePoolException {
        if (this.liveChildren == null) {
            this.createThreadResources();
        }
        return new BasicResourcePool(manager, this.start, this.min, this.max, this.inc, this.retry_attempts, this.retry_delay, this.max_age, this.age_is_absolute, this.taskRunner, this.asyncEventQueue, this.cullTimer, this);
    }
}

