/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BoundVariableDescr;
import org.drools.lang.descr.ColumnDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.LiteralDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PackageDescrDumper;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.ReturnValueDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.util.ReflectiveVisitor;

public class XmlDumper
extends ReflectiveVisitor
implements PackageDescrDumper {
    private StringBuffer xmlDump;
    private static final String eol = System.getProperty("line.separator");
    private String template;

    public synchronized String dump(PackageDescr packageDescr) {
        this.xmlDump = new StringBuffer();
        this.visitPackageDescr(packageDescr);
        return this.xmlDump.toString();
    }

    public void visitAndDescr(AndDescr andDescr) {
        this.template = new String();
        this.template = andDescr.getDescrs() != Collections.EMPTY_LIST ? "<and>" + this.processDescrList(andDescr.getDescrs()) + "</and>" : "<and> </and>";
    }

    public void visitAttributeDescr(AttributeDescr attributeDescr) {
        this.template = new String();
        this.template = "<rule-attribute name=\"" + attributeDescr.getName() + "\" value=\"" + attributeDescr.getValue() + "\" />" + eol;
    }

    public void visitBoundVariableDescr(BoundVariableDescr boundVariableDescr) {
        this.template = new String();
        this.template = "<bound-variable field-name=\"" + boundVariableDescr.getFieldName() + "\" evaluator=\"" + this.getEvaluator(boundVariableDescr.getEvaluator()) + "\" identifier=\"" + boundVariableDescr.getIdentifier() + "\" />" + eol;
    }

    public void visitColumnDescr(ColumnDescr columnDescr) {
        this.template = new String();
        this.template = columnDescr.getDescrs() != Collections.EMPTY_LIST ? (columnDescr.getIdentifier() != null ? "<column identifier=\"" + columnDescr.getIdentifier() + "\" object-type=\"" + columnDescr.getObjectType() + "\" >" + this.processDescrList(columnDescr.getDescrs()) + "</column>" + eol : "<column object-type=\"" + columnDescr.getObjectType() + "\" >" + this.processDescrList(columnDescr.getDescrs()) + "</column>" + eol) : (columnDescr.getIdentifier() != null ? "<column identifier=\"" + columnDescr.getIdentifier() + "\" object-type=\"" + columnDescr.getObjectType() + "\" > </column>" + eol : "<column object-type=\"" + columnDescr.getObjectType() + "\" > </column>" + eol);
    }

    public void visitEvalDescr(EvalDescr evalDescr) {
        this.template = new String();
        this.template = "<eval>" + evalDescr.getText() + "</eval>" + eol;
    }

    public void visitExistsDescr(ExistsDescr existsDescr) {
        this.template = new String();
        this.template = existsDescr.getDescrs() != Collections.EMPTY_LIST ? "<exists>" + this.processDescrList(existsDescr.getDescrs()) + "</exists>" : "<exists> </exists>";
    }

    public void visitFieldBindingDescr(FieldBindingDescr fieldBindingDescr) {
        this.template = new String();
        this.template = "<field-binding field-name=\"" + fieldBindingDescr.getFieldName() + "\" identifier=\"" + fieldBindingDescr.getIdentifier() + "\" />" + eol;
    }

    public void visitFunctionDescr(FunctionDescr functionDescr) {
        this.template = new String();
        String string = this.processParameters(functionDescr.getParameterNames(), functionDescr.getParameterTypes());
        this.template = "<function return-type=\"" + functionDescr.getReturnType() + "\" name=\"" + functionDescr.getName() + "\">" + eol + string + "<body>" + eol + functionDescr.getText() + eol + "</body>" + eol + "</function>" + eol;
    }

    public void visitLiteralDescr(LiteralDescr literalDescr) {
        this.template = new String();
        this.template = "<literal field-name=\"" + literalDescr.getFieldName() + "\" evaluator=\"" + this.getEvaluator(literalDescr.getEvaluator()) + "\" value=\"" + literalDescr.getText() + "\" />" + eol;
    }

    public void visitNotDescr(NotDescr notDescr) {
        this.template = new String();
        this.template = notDescr.getDescrs() != Collections.EMPTY_LIST ? "<not>" + this.processDescrList(notDescr.getDescrs()) + "</not>" : "<not> </not>";
    }

    public void visitOrDescr(OrDescr orDescr) {
        this.template = new String();
        this.template = orDescr.getDescrs() != Collections.EMPTY_LIST ? "<or>" + this.processDescrList(orDescr.getDescrs()) + "</or>" : "<or> </or>";
    }

    public void visitPackageDescr(PackageDescr packageDescr) {
        String string = packageDescr.getName();
        String string2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> " + eol + " <package name=\"" + string + "\"  " + eol + "\txmlns=\"http://drools.org/drools-3.0\" " + eol + "\txmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" " + eol + "\txs:schemaLocation=\"http://drools.org/drools-3.0 drools-3.0.xsd\"> " + eol;
        this.appendXmlDump(string2);
        this.appendXmlDump(this.processImportsList(packageDescr.getImports()));
        this.appendXmlDump(this.processGlobalsMap(packageDescr.getGlobals()));
        this.appendXmlDump(this.processFunctionsList(packageDescr.getFunctions()));
        this.appendXmlDump(this.processRules(packageDescr.getRules()));
        this.appendXmlDump("</package>");
    }

    public void visitPredicateDescr(PredicateDescr predicateDescr) {
        this.template = new String();
        this.template = "<predicate field-name=\"" + predicateDescr.getFieldName() + "\" identifier=\"" + predicateDescr.getDeclaration() + "\" >" + predicateDescr.getText() + "</predicate>" + eol;
    }

    public void visitReturnValueDescr(ReturnValueDescr returnValueDescr) {
        this.template = new String();
        this.template = "<return-value field-name=\"" + returnValueDescr.getFieldName() + "\" evaluator=\"" + this.getEvaluator(returnValueDescr.getEvaluator()) + "\" >" + returnValueDescr.getText() + "</return-value>" + eol;
    }

    public void visitQueryDescr(QueryDescr queryDescr) {
        this.template = new String();
        this.template = "<query name=\"" + queryDescr.getName() + "\">" + "<lhs>" + this.processDescrList(queryDescr.getLhs().getDescrs()) + "</lhs>" + "</query>";
    }

    private String processRules(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RuleDescr ruleDescr = (RuleDescr)iterator.next();
            String string2 = "<rule name=\"" + ruleDescr.getName() + "\">" + eol;
            String string3 = this.processAttribute(ruleDescr.getAttributes());
            String string4 = "";
            string4 = ruleDescr.getLhs().getDescrs() != Collections.EMPTY_LIST ? "<lhs>" + this.processDescrList(ruleDescr.getLhs().getDescrs()) + "</lhs>" : "<lhs> </lhs>";
            String string5 = "<rhs>" + ruleDescr.getConsequence() + "</rhs>" + eol;
            string2 = string2 + string3;
            string2 = string2 + string4;
            string2 = string2 + string5;
            string2 = string2 + "</rule>";
            string = string + string2;
        }
        return string + eol;
    }

    private String processDescrList(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            string = string + this.template;
            string = string + eol;
        }
        return string + eol;
    }

    private String processFunctionsList(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            string = string + this.template;
        }
        return string + eol;
    }

    private String processAttribute(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeDescr attributeDescr = (AttributeDescr)iterator.next();
            this.visit(attributeDescr);
            string = string + this.template;
        }
        return string + eol;
    }

    private String processParameters(List list, List list2) {
        String string = "";
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)list2.get(n);
            String string4 = "<parameter identifier=\"" + string2 + "\" type=\"" + string3 + "\" />" + eol;
            string = string + string4;
            ++n;
        }
        return string + eol;
    }

    private String processGlobalsMap(Map map) {
        String string = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            String string4 = "<global identifier=\"" + string2 + "\" type=\"" + string3 + "\" />" + eol;
            string = string + string4;
        }
        return string + eol;
    }

    private String processImportsList(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = "<import name=\"" + string2 + "\" /> " + eol;
            string = string + string3;
        }
        return string + eol;
    }

    private void appendXmlDump(String string) {
        this.xmlDump.append(string);
    }

    private String getEvaluator(String string) {
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }
}

