/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.util.Map;
import org.apache.commons.lang.StringUtils;

class Chunk {
    final String text;
    final boolean isHole;
    Chunk next;
    String padL = "";
    String padR = "";
    String value;

    Chunk(String string) {
        this.text = string;
        this.isHole = string.startsWith("{");
    }

    void buildSubtitutionKey(StringBuffer stringBuffer) {
        if (this.isHole) {
            stringBuffer.append(this.padL + this.value + this.padR);
        } else {
            stringBuffer.append(this.text);
        }
        if (this.next != null) {
            this.next.buildSubtitutionKey(stringBuffer);
        }
    }

    void process(String string) {
        if (this.isHole) {
            if (this.next == null || this.next.text == null) {
                this.storeSpacePadding(string);
                this.value = string.trim();
            } else {
                String string2 = StringUtils.substringBefore((String)string, (String)this.next.text);
                this.storeSpacePadding(string2);
                this.value = string2.trim();
            }
        } else {
            this.value = this.text;
        }
        if (this.next != null) {
            this.next.process(StringUtils.substringAfter((String)string, (String)this.value));
        }
    }

    private void storeSpacePadding(String string) {
        if (string.startsWith(" ")) {
            this.padL = " ";
        }
        if (string.endsWith(" ")) {
            this.padR = " ";
        }
    }

    void buildValueMap(Map map) {
        if (this.isHole) {
            map.put(this.text, this.value);
        }
        if (this.next != null) {
            this.next.buildValueMap(map);
        }
    }

    void addToEnd(Chunk chunk) {
        if (this.next == null) {
            this.next = chunk;
        } else {
            this.next.addToEnd(chunk);
        }
    }

    public void clearValues() {
        this.value = null;
        if (this.next != null) {
            this.next.clearValues();
        }
    }
}

