/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.xml.sax.Attributes;

public class SundayContentHandler
implements JBossXBParser.ContentHandler {
    private static final Logger log = Logger.getLogger(SundayContentHandler.class);
    private static final Object NIL = new Object();
    private final SchemaBinding schema;
    private final SchemaBindingResolver schemaResolver;
    private final StackImpl elementStack = new StackImpl();
    private final StackImpl objectStack = new StackImpl();
    private StringBuffer textContent = new StringBuffer();
    private Object root;
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();

    public SundayContentHandler(SchemaBinding schema) {
        this.schema = schema;
        this.schemaResolver = null;
    }

    public SundayContentHandler(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
        this.schema = null;
    }

    public void characters(char[] ch, int start, int length) {
        if (this.elementStack.peek() != null) {
            this.textContent.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        Object o;
        QName endName;
        block30: {
            ElementInterceptor interceptor;
            int i;
            Object parent;
            List elementHandlers;
            block28: {
                ElementBinding parentElement;
                block29: {
                    Object poped = this.pop();
                    if (poped == null) {
                        return;
                    }
                    ElementBinding elementBinding = null;
                    if (poped instanceof ElementBinding) {
                        elementBinding = (ElementBinding)poped;
                    } else {
                        while (!this.elementStack.isEmpty()) {
                            Object peeked = this.elementStack.pop();
                            if (!(peeked instanceof ElementBinding)) continue;
                            elementBinding = (ElementBinding)peeked;
                            break;
                        }
                        if (elementBinding == null) {
                            throw new JBossXBRuntimeException("Failed to endElement " + qName + ": binding not found");
                        }
                    }
                    endName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
                    o = this.objectStack.pop();
                    TypeBinding typeBinding = elementBinding.getType();
                    elementHandlers = elementBinding.getInterceptors();
                    if (o != NIL) {
                        CharactersHandler simpleType = typeBinding.getSimpleType();
                        if (this.textContent.length() > 0 || simpleType != null) {
                            Object unmarshalled;
                            String dataContent;
                            SchemaBinding schema = elementBinding.getSchema();
                            if (this.textContent.length() == 0) {
                                dataContent = null;
                            } else {
                                dataContent = this.textContent.toString();
                                if (schema != null && schema.isReplacePropertyRefs()) {
                                    dataContent = StringPropertyReplacer.replaceProperties(dataContent);
                                }
                                this.textContent.delete(0, this.textContent.length());
                            }
                            if (simpleType == null) {
                                if (schema != null && schema.isStrictSchema()) {
                                    throw new JBossXBRuntimeException("Element " + endName + " type binding " + typeBinding.getQName() + " does not include text content binding ('" + dataContent);
                                }
                                unmarshalled = dataContent;
                            } else {
                                CharactersMetaData charactersMetaData;
                                ValueMetaData valueMetaData = elementBinding.getValueMetaData();
                                if (valueMetaData == null && (charactersMetaData = typeBinding.getCharactersMetaData()) != null) {
                                    valueMetaData = charactersMetaData.getValue();
                                }
                                Object object = unmarshalled = dataContent == null ? simpleType.unmarshalEmpty(endName, typeBinding, this.nsRegistry, valueMetaData) : simpleType.unmarshal(endName, typeBinding, this.nsRegistry, valueMetaData, dataContent);
                            }
                            if (unmarshalled != null) {
                                if (o == null) {
                                    o = unmarshalled;
                                } else if (simpleType != null) {
                                    simpleType.setValue(endName, elementBinding, o, unmarshalled);
                                }
                            }
                            int i2 = elementHandlers.size();
                            while (i2-- > 0) {
                                ElementInterceptor interceptor2 = (ElementInterceptor)elementHandlers.get(i2);
                                interceptor2.characters(this.objectStack.peek(elementHandlers.size() - 1 - i2), endName, typeBinding, this.nsRegistry, dataContent);
                            }
                        }
                    } else {
                        o = null;
                    }
                    parent = this.objectStack.isEmpty() ? null : this.objectStack.peek();
                    o = typeBinding.getHandler().endElement(o, endName, elementBinding);
                    i = elementHandlers.size();
                    while (i-- > 0) {
                        interceptor = (ElementInterceptor)elementHandlers.get(i);
                        interceptor.endElement(this.objectStack.peek(elementHandlers.size() - 1 - i), endName, typeBinding);
                    }
                    i = elementHandlers.size();
                    if (i != 0) break block28;
                    parentElement = null;
                    for (int j = 0; j < this.elementStack.size(); ++j) {
                        Object peeked = this.elementStack.peek(j);
                        if (!(peeked instanceof ElementBinding)) continue;
                        parentElement = (ElementBinding)peeked;
                        break;
                    }
                    if (parent == null) break block29;
                    typeBinding.getHandler().setParent(parent, o, endName, elementBinding, parentElement);
                    break block30;
                }
                if (parentElement == null || !parentElement.getType().hasWildcard() || this.objectStack.isEmpty()) break block30;
                this.objectStack.pop();
                this.objectStack.push(o);
                if (!log.isTraceEnabled()) break block30;
                log.trace("Value of " + endName + " " + o + " is promoted as the value of its parent element.");
                break block30;
            }
            while (i-- > 0) {
                interceptor = (ElementInterceptor)elementHandlers.get(i);
                parent = this.objectStack.pop();
                interceptor.add(parent, o, endName);
                o = parent;
            }
        }
        if (this.objectStack.isEmpty()) {
            this.root = o;
        }
        if (!this.elementStack.isEmpty()) {
            Object peeked = this.elementStack.peek();
            if (peeked instanceof ElementBinding) {
                throw new JBossXBRuntimeException("Expected model group for " + endName);
            }
            ModelGroupBinding.Cursor cursor = (ModelGroupBinding.Cursor)peeked;
            if (cursor.isElementFinished()) {
                this.pop();
                if (this.elementStack.isEmpty()) {
                    throw new JBossXBRuntimeException("There is no cursor to end element: " + endName);
                }
                cursor = (ModelGroupBinding.Cursor)this.elementStack.peek();
            }
            cursor.endElement(endName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts, XSTypeDefinition type) {
        SchemaBinding schemaBinding;
        ElementBinding binding;
        QName startName;
        block17: {
            block15: {
                block16: {
                    startName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
                    binding = null;
                    schemaBinding = this.schema;
                    if (!this.elementStack.isEmpty()) break block15;
                    if (schemaBinding == null) break block16;
                    binding = schemaBinding.getElement(startName);
                    break block17;
                }
                if (this.schemaResolver == null) throw new JBossXBRuntimeException("Neither schema binding nor schema binding resolver is available!");
                String schemaLocation = atts == null ? null : Util.getSchemaLocation(atts, namespaceURI);
                schemaBinding = this.schemaResolver.resolve(namespaceURI, null, schemaLocation);
                if (schemaBinding == null) break block17;
                binding = schemaBinding.getElement(startName);
                break block17;
            }
            Object peeked = this.elementStack.peek();
            if (peeked != null) {
                ModelGroupBinding.Cursor cursor;
                if (peeked instanceof ElementBinding) {
                    ElementBinding element = (ElementBinding)peeked;
                    ModelGroupBinding modelGroup = element.getType().getModelGroup();
                    if (modelGroup == null) {
                        throw new JBossXBRuntimeException("Element " + element.getQName() + " should have a complex type!");
                    }
                    cursor = modelGroup.newCursor();
                    List newCursors = cursor.startElement(startName, atts);
                    if (!newCursors.isEmpty()) {
                        for (int i = newCursors.size() - 1; i >= 0; --i) {
                            cursor = (ModelGroupBinding.Cursor)newCursors.get(i);
                            this.push(cursor);
                        }
                        binding = cursor.getElement();
                    }
                } else {
                    while (!this.elementStack.isEmpty()) {
                        peeked = this.elementStack.peek();
                        if (peeked instanceof ElementBinding) {
                            log.warn("Element not found: " + startName);
                            break;
                        }
                        cursor = (ModelGroupBinding.Cursor)peeked;
                        List newCursors = cursor.startElement(startName, atts);
                        if (!newCursors.isEmpty()) {
                            for (int i = newCursors.size() - 2; i >= 0; --i) {
                                cursor = (ModelGroupBinding.Cursor)newCursors.get(i);
                                this.push(cursor);
                            }
                            binding = cursor.getElement();
                            break;
                        }
                        this.pop();
                    }
                }
            }
        }
        this.push(startName, binding);
        if (binding != null) {
            TypeBinding typeBinding = binding.getType();
            Object o = this.objectStack.isEmpty() ? null : this.objectStack.peek();
            List elementHandlers = binding.getInterceptors();
            for (int i = 0; i < elementHandlers.size(); ++i) {
                ElementInterceptor interceptor = (ElementInterceptor)elementHandlers.get(i);
                o = interceptor.startElement(o, startName, typeBinding);
                this.objectStack.push(o);
                interceptor.attributes(o, startName, typeBinding, atts, this.nsRegistry);
            }
            String nil = atts.getValue("xsi:nil");
            o = nil == null || !"1".equals(nil) && !"true".equals(nil) ? typeBinding.getHandler().startElement(o, startName, binding) : NIL;
            this.objectStack.push(o);
            if (o == null || o == NIL) return;
            atts = typeBinding.expandWithDefaultAttributes(atts);
            typeBinding.getHandler().attributes(o, startName, binding, atts, this.nsRegistry);
            return;
        } else {
            ElementBinding parentBinding;
            ElementBinding elementBinding = parentBinding = this.elementStack.isEmpty() ? null : (ElementBinding)this.elementStack.peek();
            if (parentBinding != null && parentBinding.getSchema() != null) {
                schemaBinding = parentBinding.getSchema();
            }
            String msg = "Element " + startName + " is not bound " + (parentBinding == null ? "as a global element." : "in type " + parentBinding.getType().getQName());
            if (schemaBinding != null && schemaBinding.isStrictSchema()) {
                throw new JBossXBRuntimeException(msg);
            }
            if (!log.isTraceEnabled()) return;
            log.trace(msg);
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.nsRegistry.addPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.nsRegistry.removePrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) {
    }

    public Object getRoot() {
        return this.root;
    }

    private void push(QName qName, ElementBinding element) {
        this.elementStack.push(element);
        if (log.isTraceEnabled()) {
            log.trace("pushed binding " + qName + "=" + element);
        }
    }

    private void push(ModelGroupBinding.Cursor cursor) {
        this.elementStack.push(cursor);
        if (log.isTraceEnabled()) {
            log.trace("pushed cursor " + cursor);
        }
    }

    private Object pop() {
        Object poped;
        Object object = poped = this.elementStack.isEmpty() ? null : this.elementStack.pop();
        if (log.isTraceEnabled()) {
            if (poped instanceof ElementBinding) {
                log.trace("poped " + ((ElementBinding)poped).getQName() + "=" + poped);
            } else {
                log.trace("poped " + poped);
            }
        }
        return poped;
    }

    static class StackImpl {
        private LinkedList list = new LinkedList();

        StackImpl() {
        }

        public void clear() {
            this.list.clear();
        }

        public void push(Object o) {
            this.list.addLast(o);
        }

        public Object pop() {
            return this.list.removeLast();
        }

        public Object peek() {
            return this.list.getLast();
        }

        public Object peek(int i) {
            return this.list.get(this.list.size() - 1 - i);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public int size() {
            return this.list.size();
        }
    }
}

