/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.parser.sax;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SaxJBossXBParser
implements JBossXBParser {
    private static final Logger log = Logger.getLogger(SaxJBossXBParser.class);
    private final SAXParser parser;
    private JBossXBParser.ContentHandler contentHandler;

    public SaxJBossXBParser() throws JBossXBException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(true);
        saxFactory.setNamespaceAware(true);
        try {
            this.parser = saxFactory.newSAXParser();
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to create a new SAX parser", e);
        }
        XMLReader reader = null;
        try {
            reader = this.parser.getXMLReader();
        }
        catch (SAXException e) {
            throw new JBossXBException("Failed to get parser's XMLReader", e);
        }
        reader.setContentHandler(new DelegatingContentHandler());
        reader.setErrorHandler(new MetaDataErrorHandler());
        reader.setEntityResolver(new JBossEntityResolver());
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setFeature("http://apache.org/xml/features/validation/schema", true);
        this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        this.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        this.setFeature("http://xml.org/sax/features/namespaces", true);
    }

    public void setEntityResolver(EntityResolver entityResolver) throws JBossXBException {
        try {
            this.parser.getXMLReader().setEntityResolver(entityResolver);
        }
        catch (SAXException e) {
            throw new JBossXBException("Failed to set EntityResolver", e);
        }
    }

    public void setProperty(String name, Object value) throws JBossXBException {
        try {
            this.parser.getXMLReader().setProperty(name, value);
        }
        catch (SAXException e) {
            throw new JBossXBException("Failed to get parser's XMLReader", e);
        }
    }

    public void setFeature(String name, boolean value) throws JBossXBException {
        try {
            this.parser.getXMLReader().setFeature(name, value);
        }
        catch (SAXException e) {
            throw new JBossXBException("Failed to get parser's XMLReader", e);
        }
    }

    public void parse(String systemId, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        try {
            this.parser.getXMLReader().parse(systemId);
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse source: " + e.getMessage(), e);
        }
    }

    public void parse(InputStream is, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        try {
            this.parser.getXMLReader().parse(new InputSource(is));
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse source: " + e.getMessage(), e);
        }
    }

    public void parse(Reader reader, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        try {
            this.parser.getXMLReader().parse(new InputSource(reader));
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse source: " + e.getMessage(), e);
        }
    }

    private static final class MetaDataErrorHandler
    implements ErrorHandler {
        private MetaDataErrorHandler() {
        }

        public void warning(SAXParseException exception) {
            log.warn(this.formatMessage(exception));
        }

        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(this.formatMessage(exception));
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(this.formatMessage(exception));
        }

        public String formatMessage(SAXParseException exception) {
            StringBuffer buffer = new StringBuffer(50);
            buffer.append(exception.getMessage()).append(" @ ");
            String location = exception.getPublicId();
            if (location != null) {
                buffer.append(location);
            } else {
                location = exception.getSystemId();
                if (location != null) {
                    buffer.append(location);
                } else {
                    buffer.append("*unknown*");
                }
            }
            buffer.append('[');
            buffer.append(exception.getLineNumber()).append(',');
            buffer.append(exception.getColumnNumber()).append(']');
            return buffer.toString();
        }
    }

    private final class DelegatingContentHandler
    implements ContentHandler {
        private DelegatingContentHandler() {
        }

        public void endDocument() {
        }

        public void startDocument() {
        }

        public void characters(char[] ch, int start, int length) {
            int i = start;
            while (i < start + length) {
                if (Character.isWhitespace(ch[i++])) continue;
                SaxJBossXBParser.this.contentHandler.characters(ch, start, length);
                break;
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void endPrefixMapping(String prefix) {
            SaxJBossXBParser.this.contentHandler.endPrefixMapping(prefix);
        }

        public void skippedEntity(String name) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void processingInstruction(String target, String data) {
            SaxJBossXBParser.this.contentHandler.processingInstruction(target, data);
        }

        public void startPrefixMapping(String prefix, String uri) {
            SaxJBossXBParser.this.contentHandler.startPrefixMapping(prefix, uri);
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            SaxJBossXBParser.this.contentHandler.endElement(namespaceURI, localName, qName);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            SaxJBossXBParser.this.contentHandler.startElement(namespaceURI, localName, qName, atts, null);
        }
    }
}

