/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class DOMUtils {
    private static Logger log = Logger.getLogger(DOMUtils.class);
    private static DocumentBuilder builder = DOMUtils.getDocumentBuilder();
    private static InheritableThreadLocal documentThreadLocal = new InheritableThreadLocal();

    private DOMUtils() {
    }

    public static DocumentBuilder getDocumentBuilder() {
        if (builder == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                builder = factory.newDocumentBuilder();
                builder.setEntityResolver(new JBossEntityResolver());
            }
            catch (ParserConfigurationException e) {
                log.error(e);
            }
        }
        return builder;
    }

    public static Element parse(String xmlString) throws IOException {
        try {
            return DOMUtils.parse(new ByteArrayInputStream(xmlString.getBytes()));
        }
        catch (IOException e) {
            log.error("Cannot parse: " + xmlString);
            throw e;
        }
    }

    public static Element parse(InputStream xmlStream) throws IOException {
        try {
            Document doc = builder.parse(xmlStream);
            Element root = doc.getDocumentElement();
            return root;
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    public static Element createElement(String localPart) {
        Document doc = DOMUtils.getOwnerDocument();
        log.trace("createElement {}" + localPart);
        return doc.createElement(localPart);
    }

    public static Element createElement(String localPart, String prefix) {
        Document doc = DOMUtils.getOwnerDocument();
        log.trace("createElement {}" + prefix + ":" + localPart);
        return doc.createElement(prefix + ":" + localPart);
    }

    public static Element createElement(String localPart, String prefix, String uri) {
        Document doc = DOMUtils.getOwnerDocument();
        if (prefix == null || prefix.length() == 0) {
            log.trace("createElement {" + uri + "}" + localPart);
            return doc.createElementNS(uri, localPart);
        }
        log.trace("createElement {" + uri + "}" + prefix + ":" + localPart);
        return doc.createElementNS(uri, prefix + ":" + localPart);
    }

    public static Element createElement(QName qname) {
        return DOMUtils.createElement(qname.getLocalPart(), qname.getPrefix(), qname.getNamespaceURI());
    }

    public static Text createTextNode(String value) {
        Document doc = DOMUtils.getOwnerDocument();
        return doc.createTextNode(value);
    }

    public static String getAttributeValue(Element el, String attrName) {
        return DOMUtils.getAttributeValue(el, new QName(attrName));
    }

    public static String getAttributeValue(Element el, QName attrName) {
        String attr = null;
        attr = "".equals(attrName.getNamespaceURI()) ? el.getAttribute(attrName.getLocalPart()) : el.getAttributeNS(attrName.getNamespaceURI(), attrName.getLocalPart());
        if ("".equals(attr)) {
            attr = null;
        }
        return attr;
    }

    public static QName getAttributeValueAsQName(Element el, String attrName) {
        return DOMUtils.getAttributeValueAsQName(el, new QName(attrName));
    }

    public static QName getAttributeValueAsQName(Element el, QName attrName) {
        QName qname = null;
        String attr = DOMUtils.getAttributeValue(el, attrName);
        if (attr != null) {
            String prefix = "";
            String localPart = attr;
            String namespaceURI = "";
            int colonIndex = attr.indexOf(":");
            if (colonIndex > 0) {
                prefix = attr.substring(0, colonIndex);
                localPart = attr.substring(colonIndex + 1);
                Element nsElement = el;
                while (namespaceURI.equals("") && nsElement != null) {
                    namespaceURI = nsElement.getAttribute("xmlns:" + prefix);
                    if (!namespaceURI.equals("")) continue;
                    nsElement = DOMUtils.getParentElement(nsElement);
                }
                if (namespaceURI.equals("")) {
                    throw new IllegalArgumentException("Cannot find namespace uri for: " + attr);
                }
            }
            qname = new QName(namespaceURI, localPart, prefix);
        }
        return qname;
    }

    public static boolean getAttributeValueAsBoolean(Element el, String attrName) {
        return DOMUtils.getAttributeValueAsBoolean(el, new QName(attrName));
    }

    public static boolean getAttributeValueAsBoolean(Element el, QName attrName) {
        String attrVal = DOMUtils.getAttributeValue(el, attrName);
        boolean ret = "true".equalsIgnoreCase(attrVal) || "1".equalsIgnoreCase(attrVal);
        return ret;
    }

    public static Integer getAttributeValueAsInteger(Element el, String attrName) {
        return DOMUtils.getAttributeValueAsInteger(el, new QName(attrName));
    }

    public static Integer getAttributeValueAsInteger(Element el, QName attrName) {
        String attrVal = DOMUtils.getAttributeValue(el, attrName);
        return attrVal != null ? new Integer(attrVal) : null;
    }

    public static void copyAttributes(Element destElement, Element srcElement) {
        NamedNodeMap attribs = srcElement.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr attr = (Attr)attribs.item(i);
            destElement.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getNodeValue());
        }
    }

    public static boolean hasChildElements(Node node) {
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static Iterator getChildElements(Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            list.add(child);
        }
        return list.iterator();
    }

    public static String getTextContent(Node node) {
        boolean hasTextContent = false;
        StringBuffer buffer = new StringBuffer();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 3) continue;
            buffer.append(child.getNodeValue());
            hasTextContent = true;
        }
        return hasTextContent ? buffer.toString() : null;
    }

    public static Element getFirstChildElement(Node node) {
        return DOMUtils.getFirstChildElementIntern(node, null);
    }

    public static Element getFirstChildElement(Node node, String nodeName) {
        return DOMUtils.getFirstChildElementIntern(node, new QName(nodeName));
    }

    public static Element getFirstChildElement(Node node, QName nodeName) {
        return DOMUtils.getFirstChildElementIntern(node, nodeName);
    }

    private static Element getFirstChildElementIntern(Node node, QName nodeName) {
        Element childElement = null;
        Iterator it = DOMUtils.getChildElementsIntern(node, nodeName);
        if (it.hasNext()) {
            childElement = (Element)it.next();
        }
        return childElement;
    }

    public static Iterator getChildElements(Node node, String nodeName) {
        return DOMUtils.getChildElementsIntern(node, new QName(nodeName));
    }

    public static Iterator getChildElements(Node node, QName nodeName) {
        return DOMUtils.getChildElementsIntern(node, nodeName);
    }

    private static Iterator getChildElementsIntern(Node node, QName nodeName) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            QName qname = new QName(child.getNamespaceURI(), child.getLocalName());
            if (nodeName != null && !qname.equals(nodeName)) continue;
            list.add(child);
        }
        return list.iterator();
    }

    public static Element getParentElement(Node node) {
        Node parent = node.getParentNode();
        return parent instanceof Element ? (Element)parent : null;
    }

    public static Document getOwnerDocument() {
        Document doc = (Document)documentThreadLocal.get();
        if (doc == null) {
            doc = builder.newDocument();
            documentThreadLocal.set(doc);
        }
        return doc;
    }

    public static void setOwnerDocument(Document doc) {
        documentThreadLocal.set(doc);
    }

    public static StringBuffer getElementContent(Element element) throws IOException, TransformerException {
        NodeList children = element.getChildNodes();
        Element content = null;
        for (int n = 0; n < children.getLength(); ++n) {
            Node node = children.item(n);
            if (node.getNodeType() != 1) continue;
            content = (Element)node;
            break;
        }
        if (content == null) {
            return null;
        }
        DOMSource source = new DOMSource(content);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        sw.close();
        return sw.getBuffer();
    }
}

