/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityInsertAction
extends EntityAction {
    private Object[] state;
    private Object version;
    private Object cacheEntry;

    public EntityInsertAction(Serializable id, Object[] state, Object instance, Object version, EntityPersister persister, SessionImplementor session) throws HibernateException {
        super(session, id, instance, persister);
        this.state = state;
        this.version = version;
    }

    public void execute() throws HibernateException {
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        Serializable id = this.getId();
        boolean veto = this.preInsert();
        if (!veto) {
            persister.insert(id, this.state, instance, session);
            EntityEntry entry = session.getPersistenceContext().getEntry(instance);
            if (entry == null) {
                throw new AssertionFailure("possible nonthreadsafe access to session");
            }
            entry.postInsert();
            if (persister.hasInsertGeneratedProperties()) {
                persister.processInsertGeneratedProperties(id, instance, this.state, session);
                if (persister.isVersionPropertyGenerated()) {
                    this.version = Versioning.getVersion(this.state, persister);
                }
                entry.postUpdate(instance, this.state, this.version);
            }
        }
        SessionFactoryImplementor factory = this.getSession().getFactory();
        if (this.isCachePutEnabled(persister, session)) {
            CacheEntry ce = new CacheEntry(this.state, persister, persister.hasUninitializedLazyProperties(instance, session.getEntityMode()), this.version, session, instance);
            this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
            CacheKey ck = new CacheKey(id, persister.getIdentifierType(), persister.getRootEntityName(), session.getEntityMode(), session.getFactory());
            boolean put = persister.getCache().insert(ck, this.cacheEntry, this.version);
            if (put && factory.getStatistics().isStatisticsEnabled()) {
                factory.getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCache().getRegionName());
            }
        }
        this.postInsert();
        if (factory.getStatistics().isStatisticsEnabled() && !veto) {
            factory.getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
    }

    private void postInsert() {
        PostInsertEventListener[] postListeners = this.getSession().getListeners().getPostInsertEventListeners();
        if (postListeners.length > 0) {
            PostInsertEvent postEvent = new PostInsertEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostInsert(postEvent);
            }
        }
    }

    private void postCommitInsert() {
        PostInsertEventListener[] postListeners = this.getSession().getListeners().getPostCommitInsertEventListeners();
        if (postListeners.length > 0) {
            PostInsertEvent postEvent = new PostInsertEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostInsert(postEvent);
            }
        }
    }

    private boolean preInsert() {
        PreInsertEventListener[] preListeners = this.getSession().getListeners().getPreInsertEventListeners();
        boolean veto = false;
        if (preListeners.length > 0) {
            PreInsertEvent preEvent = new PreInsertEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), this.getSession());
            for (int i = 0; i < preListeners.length; ++i) {
                veto = preListeners[i].onPreInsert(preEvent) || veto;
            }
        }
        return veto;
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        EntityPersister persister = this.getPersister();
        if (success && this.isCachePutEnabled(persister, this.getSession())) {
            CacheKey ck = new CacheKey(this.getId(), persister.getIdentifierType(), persister.getRootEntityName(), this.getSession().getEntityMode(), this.getSession().getFactory());
            boolean put = persister.getCache().afterInsert(ck, this.cacheEntry, this.version);
            if (put && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                this.getSession().getFactory().getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCache().getRegionName());
            }
        }
        this.postCommitInsert();
    }

    protected boolean hasPostCommitEventListeners() {
        return this.getSession().getListeners().getPostCommitInsertEventListeners().length > 0;
    }

    private boolean isCachePutEnabled(EntityPersister persister, SessionImplementor session) {
        return persister.hasCache() && !persister.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled();
    }
}

