/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import com.icesoft.faces.webapp.xmlhttp.BlockingResponseState;
import com.icesoft.faces.webapp.xmlhttp.ContinuationResponseState;
import com.icesoft.faces.webapp.xmlhttp.PortletBlockingResponseState;
import com.icesoft.faces.webapp.xmlhttp.ResponseState;
import javax.portlet.PortletSession;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseStateManager {
    public static final String ICEFACES_ID_KEY = "icefacesID";
    public static final String RESPONSE_STATE = "com.icesoft.faces.ResponseState";
    private static Log log;
    private static final String ASYNC_SERVER_KEY = "com.icesoft.faces.async.server";
    private static final String ASYNC_RESPONSE_STATE_MANAGER_CLASS_NAME = "com.icesoft.faces.async.server.AsyncResponseStateManager";
    private static ResponseStateManager mgr;
    private static boolean hasContinuations;

    public static synchronized ResponseStateManager getResponseStateManager(ServletContext context) {
        boolean tryAsync;
        block9: {
            if (mgr != null) {
                return mgr;
            }
            tryAsync = false;
            try {
                tryAsync = Boolean.valueOf(context.getInitParameter(ASYNC_SERVER_KEY));
            }
            catch (NullPointerException e) {
                tryAsync = false;
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)"com.icesoft.faces.async.server not defined.");
            }
        }
        if (tryAsync) {
            try {
                mgr = (ResponseStateManager)Class.forName(ASYNC_RESPONSE_STATE_MANAGER_CLASS_NAME).newInstance();
            }
            catch (Exception e) {
                mgr = new ResponseStateManager();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"AsyncResponseStateManager class not found.");
                }
            }
        } else {
            mgr = new ResponseStateManager();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("using response state manager: " + mgr.getClass().getName()));
        }
        return mgr;
    }

    public ResponseState createState(HttpSession session, String iceID, String viewNumber) {
        if (hasContinuations) {
            return new ContinuationResponseState(session, iceID, viewNumber);
        }
        return new BlockingResponseState(session, iceID, viewNumber);
    }

    public ResponseState createState(PortletSession session, String iceID, String viewNumber) {
        return new PortletBlockingResponseState(session, iceID, viewNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseState getState(HttpSession session, String viewNumber) {
        String iceID = (String)session.getAttribute(ICEFACES_ID_KEY);
        ResponseState state = null;
        String string = iceID;
        synchronized (string) {
            state = (ResponseState)session.getAttribute(this.getStateKey(viewNumber));
            if (null == state) {
                state = this.createState(session, iceID, viewNumber);
                session.setAttribute(this.getStateKey(viewNumber), (Object)state);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResponseState getState(PortletSession session, String viewNumber) {
        String iceID = (String)session.getAttribute(ICEFACES_ID_KEY, 1);
        ResponseState state = null;
        String string = iceID;
        synchronized (string) {
            state = (ResponseState)session.getAttribute(this.getStateKey(viewNumber), 1);
            if (null == state) {
                state = this.createState(session, iceID, viewNumber);
                session.setAttribute(this.getStateKey(viewNumber), (Object)state, 1);
            }
        }
        return state;
    }

    String getStateKey(String viewNumber) {
        return viewNumber + "/" + RESPONSE_STATE;
    }

    static {
        block3: {
            log = LogFactory.getLog((Class)ResponseStateManager.class);
            hasContinuations = false;
            try {
                Class<?> continuationClass = Class.forName("org.mortbay.util.ajax.Continuation");
                if (null != continuationClass) {
                    hasContinuations = true;
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("continuations not supported " + t.getMessage()));
            }
        }
    }
}

