/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import com.icesoft.faces.util.DOMUtils;
import com.icesoft.faces.webapp.xmlhttp.BlockingResponseState;
import com.icesoft.faces.webapp.xmlhttp.PortletKicker;
import com.icesoft.faces.webapp.xmlhttp.ResponseState;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class PortletBlockingResponseState
implements ResponseState,
Serializable {
    protected static Log log = LogFactory.getLog((Class)BlockingResponseState.class);
    protected int maxNumberOfUpdates = 50;
    protected Object eventLock = new Object();
    protected PortletKicker kicker;
    protected Collection updates = new ArrayList();
    protected String focusID;
    protected boolean isCancelled = false;
    protected String iceID;
    protected String viewNumber;
    private final int maxUnflushed = 10;
    private int unflushed = 0;
    private PortletSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletBlockingResponseState(PortletSession session, String iceID, String viewNumber) {
        if (iceID == null || viewNumber == null) {
            throw new IllegalArgumentException("iceID and viewNumber must be set");
        }
        this.session = session;
        this.iceID = iceID;
        String string = iceID;
        synchronized (string) {
            this.kicker = (PortletKicker)session.getAttribute(iceID + "/kicker", 1);
            if (null == this.kicker) {
                this.kicker = new PortletKicker();
                session.setAttribute(iceID + "/kicker", (Object)this.kicker, 1);
            }
        }
        this.viewNumber = viewNumber;
    }

    public Object getEventLock() {
        return this.eventLock;
    }

    public String getFocusID() {
        return this.focusID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block(HttpServletRequest request) {
        long left = 0L;
        PortletKicker portletKicker = this.kicker;
        synchronized (portletKicker) {
            this.kicker.notifyAll();
            while (!this.isCancelled && !this.kicker.isKicked && (left = this.remainingMillis()) > 0L) {
                try {
                    this.kicker.wait(left);
                }
                catch (InterruptedException e) {}
            }
            this.kicker.isKicked = false;
        }
        if (this.remainingMillis() <= 0L) {
            throw new RuntimeException("BlockingResponseState.block() Expired");
        }
        if (this.isCancelled) {
            try {
                Thread.sleep(500L);
                log.debug((Object)"Cancelled block slept for browser abort");
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.isCancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"DOMUpdate flushed");
        }
        PortletKicker portletKicker = this.kicker;
        synchronized (portletKicker) {
            ++this.unflushed;
            this.kicker.isKicked = true;
            this.kicker.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        PortletKicker portletKicker = this.kicker;
        synchronized (portletKicker) {
            this.kicker.isKicked = true;
            this.isCancelled = true;
            this.kicker.notifyAll();
        }
    }

    private long remainingMillis() {
        long currentMillis = Calendar.getInstance().getTime().getTime();
        long accessedMillis = 0L;
        long maxInactiveInterval = 1L;
        accessedMillis = this.session instanceof PortletSession ? this.session.getLastAccessedTime() : ((HttpSession)this.session).getLastAccessedTime();
        maxInactiveInterval = this.session instanceof PortletSession ? (long)this.session.getMaxInactiveInterval() : (long)((HttpSession)this.session).getMaxInactiveInterval();
        return maxInactiveInterval * 1000L - (currentMillis - accessedMillis);
    }

    public void setFocusID(String focusID) {
        this.focusID = focusID;
    }

    public boolean hasHandler() {
        return false;
    }

    public void writeElement(Element element) {
        if (null == element) {
            return;
        }
        if (this.unflushed > 10) {
            throw new RuntimeException("viewNumber " + this.viewNumber + " update queue exceeded " + this.unflushed);
        }
        String nodeString = DOMUtils.nodeToString(element);
        this.addUpdate(element.getAttribute("id"), nodeString);
        if (log.isTraceEnabled()) {
            log.trace((Object)nodeString);
        }
    }

    public void flush(HttpSession session) {
        this.flush();
    }

    public String getFocusID(HttpSession session) {
        return this.getFocusID();
    }

    public void writeElement(HttpSession session, Element element) {
        this.writeElement(element);
    }

    public void serialize(Writer writer) throws IOException {
        Iterator i = this.updates.iterator();
        while (i.hasNext()) {
            ((Update)i.next()).serialize(writer);
        }
        this.updates.clear();
        this.unflushed = 0;
    }

    private void addUpdate(String address, String content) {
        this.updates.add(new Update(address, content));
    }

    private static class Update {
        private String address;
        private String content;

        public Update(String address, String content) {
            this.address = address;
            this.content = content;
        }

        public void serialize(Writer writer) throws IOException {
            writer.write("<update address=\"" + this.address + "\"><![CDATA[" + this.content + "]]></update>");
        }
    }
}

