/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.MenuRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SelectManyCheckboxListRenderer
extends MenuRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String style;
        this.validateParameters(facesContext, uiComponent, null);
        int counter = 0;
        boolean renderVertically = false;
        String layout = (String)uiComponent.getAttributes().get("layout");
        if (layout != null) {
            renderVertically = layout.equalsIgnoreCase("pageDirection");
        }
        int border = this.getBorderSize(uiComponent);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        Element rootTR = null;
        if (domContext.isInitialized()) {
            DOMContext.removeChildrenByTagName((Element)domContext.getRootNode(), "tr");
        } else {
            Element root = domContext.createElement("table");
            domContext.setRootNode(root);
            if (SelectManyCheckboxListRenderer.idNotNull(uiComponent)) {
                SelectManyCheckboxListRenderer.setRootElementId(facesContext, root, uiComponent);
            }
        }
        Element rootTable = (Element)domContext.getRootNode();
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            rootTable.setAttribute("class", styleClass);
        }
        if ((style = (String)uiComponent.getAttributes().get("style")) != null) {
            rootTable.setAttribute("style", style);
        }
        rootTable.setAttribute("border", new Integer(border).toString());
        if (!renderVertically) {
            rootTR = domContext.createElement("tr");
            rootTable.appendChild(rootTR);
        }
        Iterator options = this.getSelectItems(uiComponent);
        Object componentValue = ((UIInput)uiComponent).getValue();
        while (options.hasNext()) {
            SelectItem nextSelectItem = (SelectItem)options.next();
            ++counter;
            if (nextSelectItem instanceof SelectItemGroup) {
                Element nextTR = null;
                Element nextTD = null;
                if (nextSelectItem.getLabel() != null) {
                    if (renderVertically) {
                        nextTR = domContext.createElement("tr");
                        rootTable.appendChild(nextTR);
                    }
                    nextTD = domContext.createElement("td");
                    nextTR.appendChild(nextTD);
                    Text label = domContext.getDocument().createTextNode(nextSelectItem.getLabel());
                    nextTD.appendChild(label);
                }
                if (renderVertically) {
                    nextTR = domContext.createElement("tr");
                    rootTable.appendChild(nextTR);
                }
                nextTD = domContext.createElement("td");
                nextTR.appendChild(nextTD);
                SelectItem[] selectItemsArray = ((SelectItemGroup)nextSelectItem).getSelectItems();
                for (int i = 0; i < selectItemsArray.length; ++i) {
                    this.renderOption(facesContext, uiComponent, selectItemsArray[i], renderVertically, nextTR, counter, componentValue);
                }
                continue;
            }
            this.renderOption(facesContext, uiComponent, nextSelectItem, renderVertically, rootTR, counter, componentValue);
        }
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    private int getBorderSize(UIComponent uiComponent) {
        int border = 0;
        Object borderAttribute = uiComponent.getAttributes().get("border");
        if (borderAttribute instanceof Integer) {
            if ((Integer)borderAttribute != Integer.MIN_VALUE) {
                border = (Integer)borderAttribute;
            }
        } else {
            try {
                border = Integer.valueOf(borderAttribute.toString());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return border;
    }

    protected void renderOption(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, boolean renderVertically, Element rootTR, int counter, Object componentValue) throws IOException {
        String selectItemLabel;
        boolean isSelected;
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        Element rootTable = (Element)domContext.getRootNode();
        boolean disabled = false;
        if (uiComponent.getAttributes().get("disabled") != null && uiComponent.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            disabled = true;
        }
        if (selectItem.isDisabled()) {
            disabled = true;
        }
        String labelClass = (String)uiComponent.getAttributes().get("styleClass");
        if (disabled) {
            labelClass = labelClass + "-dis";
        }
        if (renderVertically) {
            rootTR = domContext.createElement("tr");
            rootTable.appendChild(rootTR);
        }
        Element td = domContext.createElement("td");
        rootTR.appendChild(td);
        Element label = domContext.createElement("label");
        td.appendChild(label);
        if (labelClass != null) {
            label.setAttribute("class", labelClass);
        }
        Element inputElement = domContext.createElement("input");
        inputElement.setAttribute("name", uiComponent.getClientId(facesContext));
        inputElement.setAttribute("id", uiComponent.getClientId(facesContext) + ":_" + counter);
        label.appendChild(inputElement);
        HashSet<String> excludes = new HashSet<String>();
        String accesskey = (String)uiComponent.getAttributes().get("accesskey");
        if (accesskey != null) {
            inputElement.setAttribute("accesskey", accesskey);
            excludes.add("accesskey");
        }
        String formattedOptionValue = this.formatComponentValue(facesContext, uiComponent, selectItem.getValue());
        inputElement.setAttribute("value", formattedOptionValue);
        inputElement.setAttribute("type", "checkbox");
        Object[] submittedValues = this.getSubmittedSelectedValues(uiComponent);
        if (submittedValues != null) {
            isSelected = this.isSelected((Object)formattedOptionValue, submittedValues);
        } else {
            Object selectedValues = this.getCurrentSelectedValues(uiComponent);
            isSelected = this.isSelected(selectItem.getValue(), selectedValues);
        }
        if (isSelected) {
            inputElement.setAttribute("checked", Boolean.TRUE.toString());
        }
        if (disabled) {
            inputElement.setAttribute("disabled", "disabled");
        }
        if ((selectItemLabel = selectItem.getLabel()) != null) {
            Text textNode = domContext.getDocument().createTextNode(selectItemLabel);
            inputElement.appendChild(textNode);
        }
        this.addJavaScript(facesContext, uiComponent, inputElement, excludes);
        excludes.add("style");
        excludes.add("border");
        excludes.add("readonly");
        Iterator passTrhuAttributes = PassThruAttributeRenderer.getpassThruAttributeNames().iterator();
        while (passTrhuAttributes.hasNext()) {
            String passThruAttribute = passTrhuAttributes.next().toString();
            Object attOnComponent = uiComponent.getAttributes().get(passThruAttribute);
            if (attOnComponent == null || excludes.contains(passThruAttribute)) continue;
            inputElement.setAttribute(passThruAttribute, attOnComponent.toString());
        }
    }

    protected void addJavaScript(FacesContext facesContext, UIComponent uiComponent, Element root, Set excludes) {
    }
}

