/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import java.lang.reflect.Method;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FacesContextFactoryImpl
extends FacesContextFactory {
    protected static Log log = LogFactory.getLog((Class)FacesContextFactoryImpl.class);
    public static final String SERVLET_KEY = "servletkey";
    public static final String PERSISTENT = "persistent";
    private FacesContextFactory delegate;

    public FacesContextFactoryImpl() {
    }

    public FacesContextFactoryImpl(FacesContextFactory delegate) {
        this.delegate = delegate;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        if (context == null || request == null || response == null || lifecycle == null) {
            throw new NullPointerException();
        }
        if (this.shouldDelegate(request)) {
            return this.delegate.getFacesContext(context, request, response, lifecycle);
        }
        BridgeExternalContext externalContext = new BridgeExternalContext(context, request, response);
        return new BridgeFacesContext(externalContext);
    }

    private boolean shouldDelegate(Object request) {
        String servletType;
        Class<?> portletRequestClass;
        Method getAttributeMethod;
        block9: {
            if (this.delegate == null) {
                return false;
            }
            getAttributeMethod = null;
            portletRequestClass = null;
            try {
                portletRequestClass = Class.forName("javax.portlet.PortletRequest");
                getAttributeMethod = portletRequestClass.getMethod("getAttribute", String.class);
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)("Portlet classes not available: " + t));
            }
        }
        if (null != portletRequestClass && portletRequestClass.isInstance(request)) {
            String portletType;
            block10: {
                portletType = null;
                try {
                    portletType = (String)getAttributeMethod.invoke(request, SERVLET_KEY);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block10;
                    log.warn((Object)"Reflection failure: request.getAttribute", (Throwable)e);
                }
            }
            if (portletType != null && portletType.equalsIgnoreCase(PERSISTENT)) {
                return false;
            }
        } else if (request instanceof ServletRequest && (servletType = (String)((ServletRequest)request).getAttribute(SERVLET_KEY)) != null && servletType.equalsIgnoreCase(PERSISTENT)) {
            return false;
        }
        return true;
    }
}

