/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMSerializer {
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static Transformer PrettyPrintingTransformer;
    private static Transformer NormalPrintingTransformer;
    private Result result;
    private Properties properties = new Properties();
    private Transformer transformer = NormalPrintingTransformer;

    public DOMSerializer(Writer writer) {
        this.result = new StreamResult(writer);
    }

    public DOMSerializer(Writer writer, String publicId, String systemId) {
        this.result = new StreamResult(writer);
        this.properties.setProperty("doctype-public", publicId);
        this.properties.setProperty("doctype-system", systemId);
        this.properties.setProperty("omit-xml-declaration", "no");
    }

    public void serialize(Document document) throws TransformerException {
        this.transformer.setOutputProperties(this.properties);
        this.transformer.transform(new DOMSource(document), this.result);
    }

    public void serialize(Node node) throws TransformerException {
        this.transformer.setOutputProperties(this.properties);
        this.transformer.transform(new DOMSource(node), this.result);
    }

    public void printPretty() {
        this.transformer = PrettyPrintingTransformer;
    }

    public void outputAsHTML() {
        this.properties.setProperty("method", "html");
    }

    public void outputAsXML() {
        this.properties.setProperty("method", "xml");
    }

    public void ommitXMLDeclaration() {
        this.properties.setProperty("omit-xml-declaration", "yes");
    }

    static {
        try {
            PrettyPrintingTransformer = transformerFactory.newTransformer(new StreamSource(DOMSerializer.class.getResourceAsStream("pretty-printing.xslt")));
            NormalPrintingTransformer = transformerFactory.newTransformer(new StreamSource(DOMSerializer.class.getResourceAsStream("normal-printing.xslt")));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

