/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.AsyncRenderer;
import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.faces.async.render.Renderable;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupAsyncRenderer
implements AsyncRenderer {
    private static Log log = LogFactory.getLog((Class)GroupAsyncRenderer.class);
    protected String name;
    protected Set group = new CopyOnWriteArraySet();
    protected RenderManager renderManager;
    protected boolean stopRequested = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRenderManager(RenderManager renderManager) {
        this.renderManager = renderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Renderable renderable) {
        Set set = this.group;
        synchronized (set) {
            if (!this.contains(renderable)) {
                if (this.group.add(new WeakReference<Renderable>(renderable))) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(this.name + " added " + renderable));
                    }
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)(this.name + " already contains " + renderable));
                }
            }
        }
    }

    public boolean contains(Renderable renderable) {
        Iterator iter = this.group.iterator();
        while (iter.hasNext()) {
            if (renderable != (Renderable)((WeakReference)iter.next()).get()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Renderable renderable) {
        Set set = this.group;
        synchronized (set) {
            Iterator iter = this.group.iterator();
            while (iter.hasNext()) {
                WeakReference ref = (WeakReference)iter.next();
                if (renderable != (Renderable)ref.get()) continue;
                this.group.remove(ref);
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this.name + " removing " + renderable));
                }
                return;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)(this.name + " does not contain " + renderable));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set set = this.group;
        synchronized (set) {
            this.group.clear();
        }
    }

    public boolean isEmpty() {
        return this.group.isEmpty();
    }

    public void requestRender() {
        if (this.renderManager == null) {
            String message = "RenderManager has not been set";
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new IllegalStateException(message);
        }
        Iterator iter = this.group.iterator();
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.name + " preparing to render " + this.group.size()));
        }
        this.stopRequested = false;
        while (iter.hasNext() && !this.stopRequested) {
            Renderable renderable = (Renderable)((WeakReference)iter.next()).get();
            this.renderManager.requestRender(renderable);
        }
    }

    public void requestStop() {
        this.stopRequested = true;
    }

    public void dispose() {
        this.requestStop();
        this.group.clear();
        this.group = null;
        this.renderManager.removeRenderer(this);
        this.name = null;
        this.renderManager = null;
    }
}

