/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.jboss.tools.buildmagic.task.MissingAttributeException;
import org.jboss.tools.buildmagic.task.ResolveProperties;
import org.jboss.tools.buildmagic.task.VariableTask;

public class Set
extends VariableTask {
    protected List elements = new LinkedList();

    public Set() {
        this.type = 3;
    }

    public void execute() throws BuildException {
        if (this.name == null) {
            throw new MissingAttributeException("name", this);
        }
        if (this.type == 3) {
            Object value = this.getObject();
            this.project.getReferences().put(this.name, value);
            this.log.verbose("set reference " + this.name + "=" + value);
        } else {
            String value = this.getString();
            String ptype = null;
            Hashtable map = null;
            switch (this.type) {
                case 0: {
                    map = this.project.getProperties();
                    ptype = "project";
                    break;
                }
                case 1: {
                    map = this.project.getUserProperties();
                    ptype = "user";
                    break;
                }
                case 2: {
                    map = System.getProperties();
                    ptype = "system";
                }
            }
            map.put(this.name, value);
            this.log.verbose("set " + ptype + " property " + this.name + "=" + value);
        }
    }

    protected Object getObject() {
        Path path = new Path(this.project);
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Path) {
                path.append((Path)obj);
                continue;
            }
            path.append((Path)new RPath(this.project, obj.toString()));
        }
        return path;
    }

    protected String getString() {
        return this.getObject().toString();
    }

    public Path createPath() {
        Path path = new Path(this.project);
        this.elements.add(path);
        return path;
    }

    protected class RPath
    extends Path {
        protected Project project;

        public RPath(Project project) {
            super(project);
            this.project = project;
        }

        public RPath(Project project, String path) {
            super(project, path);
        }

        public String[] list() {
            String[] values = super.list();
            Hashtable props = this.project.getProperties();
            int i = 0;
            while (i < values.length) {
                values[i] = ResolveProperties.subst(values[i], props, false);
                ++i;
            }
            return values;
        }
    }
}

