/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.net.protocol.URLLister;
import org.jboss.net.protocol.URLListerBase;

public class FileURLLister
extends URLListerBase {
    public Collection listMembers(URL baseUrl, URLLister.URLFilter filter) throws IOException {
        return this.listMembers(baseUrl, filter, false);
    }

    public Collection listMembers(URL baseUrl, URLLister.URLFilter filter, boolean scanNonDottedSubDirs) throws IOException {
        File directory = new File(baseUrl.getPath());
        if (!directory.exists()) {
            throw new FileNotFoundException(directory.toString());
        }
        return this.listFiles(baseUrl, filter, scanNonDottedSubDirs);
    }

    protected Collection listFiles(URL baseUrl, final URLLister.URLFilter filter, boolean scanNonDottedSubDirs) {
        final File directory = new File(baseUrl.getPath());
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                try {
                    return filter.accept(directory.toURL(), file.getName());
                }
                catch (Exception forgetIt) {
                    forgetIt.printStackTrace();
                    return true;
                }
            }
        });
        if (scanNonDottedSubDirs) {
            ArrayList<URL> result = new ArrayList<URL>();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (this.doesDirTriggersRecursiveSearch(file)) {
                    result.addAll(this.listFiles(this.prependDirToUrl(baseUrl, file.getName(), true), filter, scanNonDottedSubDirs));
                } else {
                    result.add(this.fileToURL(baseUrl, file));
                }
                ++i;
            }
            return result;
        }
        return this.filesToURLs(baseUrl, files);
    }

    protected boolean doesDirTriggersRecursiveSearch(File file) {
        return file.isDirectory() && file.getName().indexOf(".") == -1;
    }

    protected URL prependDirToUrl(URL baseUrl, String addenda, boolean isDirectory) {
        try {
            String base = baseUrl.toString();
            return new URL(base + (base.endsWith("/") ? "" : "/") + addenda + (isDirectory ? "/" : ""));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException();
        }
    }

    protected Collection filesToURLs(URL baseUrl, File[] files) {
        ArrayList<URL> result = new ArrayList<URL>(files.length);
        int i = 0;
        while (i < files.length) {
            result.add(this.fileToURL(baseUrl, files[i]));
            ++i;
        }
        return result;
    }

    protected URL fileToURL(URL baseUrl, File file) {
        return this.prependDirToUrl(baseUrl, file.getName(), file.isDirectory());
    }
}

