/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheConfigurationLoader;
import org.ajax4jsf.cache.CacheException;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.CacheLoader;
import org.ajax4jsf.cache.CacheManager;
import org.ajax4jsf.cache.ServletContextInitMap;
import org.ajax4jsf.framework.ajax.xmlfilter.BaseFilter;
import org.ajax4jsf.framework.ajax.xmlfilter.CacheContent;
import org.ajax4jsf.framework.resource.CacheKey;
import org.ajax4jsf.framework.resource.CachedResourceContext;
import org.ajax4jsf.framework.resource.FacesResourceContext;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;
import org.ajax4jsf.framework.resource.ResourceContext;
import org.ajax4jsf.framework.resource.ResourceLifecycle;
import org.ajax4jsf.framework.resource.ResourceNotFoundException;
import org.ajax4jsf.framework.resource.ServletResourceContext;
import org.ajax4jsf.framework.util.config.WebXml;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternetResourceService
implements CacheLoader,
CacheConfigurationLoader {
    private static final Log log = LogFactory.getLog((Class)InternetResourceService.class);
    static final String ENABLE_CACHING_PARAMETER = "enable-cache";
    private static final String RESOURCE_LIFECYCLE_PARAMETER = "org.ajax4jsf.RESOURCE_LIFECYCLE";
    private FilterConfig filterConfig;
    private boolean cacheEnabled = true;
    private Cache cache = null;
    private FacesContextFactory contextFactory;
    private String lifecycleClass;
    private ResourceLifecycle lifecycle;
    private InternetResourceBuilder resourceBuilder;
    private WebXml webXml;

    public void setCacheEnabled(boolean b) {
        this.cacheEnabled = b;
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        ServletContext servletContext = config.getServletContext();
        if ("false".equalsIgnoreCase(config.getInitParameter(ENABLE_CACHING_PARAMETER))) {
            this.setCacheEnabled(false);
        } else {
            try {
                CacheManager cacheManager = CacheManager.getInstance();
                ServletContextInitMap env = new ServletContextInitMap(servletContext);
                CacheFactory cacheFactory = cacheManager.getCacheFactory(env);
                this.cache = cacheFactory.createCache(env, this, this);
            }
            catch (CacheException e) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
        }
        this.lifecycleClass = servletContext.getInitParameter(RESOURCE_LIFECYCLE_PARAMETER);
        if (this.lifecycleClass != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass(this.lifecycleClass);
                this.lifecycle = (ResourceLifecycle)((Object)clazz.newInstance());
            }
            catch (Exception e) {
                throw new FacesException("Error create instance of resource Lifecycle " + this.lifecycleClass, (Throwable)e);
            }
        } else {
            this.lifecycle = new ResourceLifecycle();
        }
        this.webXml = new WebXml();
        this.webXml.init(servletContext, this.filterConfig.getFilterName());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Resources service initialized");
        }
    }

    public boolean serviceResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String resourceKey = this.webXml.getFacesResourceKey(httpServletRequest);
        if (null != resourceKey) {
            this.serviceResource(resourceKey, httpServletRequest, httpServletResponse);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serviceResource(String resourceKey, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        InternetResource resource;
        try {
            resource = this.getResourceBuilder().getResourceForKey(resourceKey);
        }
        catch (ResourceNotFoundException e) {
            throw new ServletException((Throwable)((Object)e));
        }
        Object resourceDataForKey = this.getResourceBuilder().getResourceDataForKey(resourceKey);
        if (resource.isCacheable(null) && this.cacheEnabled) {
            try {
                long lastModified;
                long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                if (ifModifiedSince >= 0L && (lastModified = resource.getLastModified(null).getTime() - 1000L) <= ifModifiedSince) {
                    response.setStatus(304);
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)Messages.getMessage("PARSING_IF_MODIFIED_SINCE_WARNING"), (Throwable)e);
            }
            String cacheKey = resourceKey;
            CacheKey key = new CacheKey(resourceDataForKey, request, response, resource);
            try {
                CacheContent content = (CacheContent)this.cache.get(cacheKey, key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage("GET_CONTENT_FROM_CACHE_INFO", cacheKey));
                }
                content.sendHeaders(response);
                Date expired = resource.getExpired(null);
                if (expired != null) {
                    response.setDateHeader("Expires", expired.getTime());
                } else {
                    response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
                }
                if (request.getMethod().equals("HEAD")) return;
                content.send(response);
                return;
            }
            catch (CacheException e) {
                log.error((Object)Messages.getMessage("SEND_RESOURCE_ERROR"), (Throwable)e);
                throw new ServletException(Messages.getMessage("SEND_RESOURCE_ERROR_2", e.getMessage()), (Throwable)e);
            }
        }
        this.sendResource(resource, request, response, resourceDataForKey);
    }

    protected ResourceContext sendResource(InternetResource resource, HttpServletRequest request, HttpServletResponse response, Object data) throws IOException {
        ResourceContext resourceContext = this.getResourceContext(resource, request, response);
        resourceContext.setResourceData(data);
        this.getLifecycle().send(resourceContext, resource);
        resourceContext.release();
        return resourceContext;
    }

    protected ResourceContext getResourceContext(InternetResource resource, HttpServletRequest request, HttpServletResponse response) throws FacesException {
        ResourceContext resourceContext;
        FacesContext facesContext = null;
        if (resource.requireFacesContext()) {
            facesContext = this.getFacesContext((ServletRequest)request, (ServletResponse)response);
            resourceContext = new FacesResourceContext(facesContext);
        } else {
            resourceContext = new ServletResourceContext(this.getServletContext(), request, response);
        }
        if (resource.isCacheable(null) && this.cacheEnabled) {
            resourceContext = new CachedResourceContext(resourceContext);
        }
        return resourceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(String name) {
        Properties properties = new Properties();
        InputStream props = BaseFilter.class.getResourceAsStream(name);
        if (null != props) {
            try {
                properties.load(props);
            }
            catch (IOException e) {
                log.warn((Object)Messages.getMessage("READING_PROPERTIES_ERROR", name), (Throwable)e);
            }
            finally {
                try {
                    props.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    protected ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected ResourceLifecycle getLifecycle() throws FacesException {
        return this.lifecycle;
    }

    protected synchronized FacesContextFactory getContextFactory() {
        if (this.contextFactory == null) {
            this.contextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        return this.contextFactory;
    }

    protected FacesContext getFacesContext(ServletRequest request, ServletResponse response) throws FacesException {
        return this.getContextFactory().getFacesContext((Object)this.getServletContext(), (Object)request, (Object)response, (Lifecycle)this.getLifecycle());
    }

    protected InternetResourceBuilder getResourceBuilder() {
        if (this.resourceBuilder == null) {
            this.resourceBuilder = InternetResourceBuilder.getInstance();
        }
        return this.resourceBuilder;
    }

    public Object load(Object key, Object context) throws CacheException {
        CacheKey cacheKey = (CacheKey)context;
        CachedResourceContext resourceContext = (CachedResourceContext)this.getResourceContext(cacheKey.getResource(), cacheKey.getRequest(), cacheKey.getResponse());
        resourceContext.setResourceData(cacheKey.getResourceData());
        try {
            this.getLifecycle().send(resourceContext, cacheKey.getResource());
        }
        catch (IOException e) {
            throw new CacheException(e.getMessage(), e);
        }
        resourceContext.release();
        return resourceContext.getContent();
    }

    public Properties loadProperties(String name) {
        return this.getProperties(name);
    }
}

