/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import org.jboss.aop.annotation.PortableAnnotationElement;
import org.jboss.aop.util.ReflectToJavassist;

public class AnnotationElement
extends PortableAnnotationElement {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static Object getVisibleAnnotation(Method method, Class annotation) {
        try {
            CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
            if (ctMethod == null) {
                return null;
            }
            MethodInfo mi = ctMethod.getMethodInfo2();
            AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) {
                return null;
            }
            return AnnotationElement.create(visible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getVisibleAnnotation(Constructor con, Class annotation) {
        try {
            CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
            if (ctMethod == null) {
                return null;
            }
            MethodInfo mi = ctMethod.getMethodInfo2();
            AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) {
                return null;
            }
            return AnnotationElement.create(visible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getVisibleAnnotation(Field field, Class annotation) {
        try {
            CtField ctField = ReflectToJavassist.fieldToJavassist(field);
            FieldInfo mi = ctField.getFieldInfo2();
            AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) {
                return null;
            }
            return AnnotationElement.create(visible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getVisibleAnnotation(Class clazz, Class annotation) {
        try {
            ClassFile cf = AnnotationElement.getClassFile(clazz);
            AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) {
                return null;
            }
            return AnnotationElement.create(visible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isVisibleAnnotationPresent(Field field, Class annotation) throws Exception {
        CtField ctMethod = ReflectToJavassist.fieldToJavassist(field);
        return AnnotationElement.isVisibleAnnotationPresent(ctMethod, annotation.getName());
    }

    public static boolean isVisibleAnnotationPresent(Class clazz, Class annotation) throws Exception {
        ClassFile cf = AnnotationElement.getClassFile(clazz);
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return false;
        }
        return visible.getAnnotation(annotation.getName()) != null;
    }

    public static boolean isVisibleAnnotationPresent(Constructor con, Class annotation) throws Exception {
        CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
        return AnnotationElement.isVisibleAnnotationPresent(ctMethod, annotation.getName());
    }

    public static boolean isVisibleAnnotationPresent(Method method, Class annotation) throws Exception {
        CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
        if (ctMethod == null) {
            return false;
        }
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return false;
        }
        return visible.getAnnotation(annotation.getName()) != null;
    }

    public static Object[] getVisibleAnnotations(Class clazz) throws Exception {
        try {
            ClassFile cf = AnnotationElement.getClassFile(clazz);
            AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) {
                return EMPTY_OBJECT_ARRAY;
            }
            return AnnotationElement.getVisibleAnnotations(visible);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object[] getVisibleAnnotations(Method m) throws Exception {
        CtMethod ctMethod = ReflectToJavassist.methodToJavassist(m);
        if (ctMethod == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        return AnnotationElement.getVisibleAnnotations(visible);
    }

    public static Object[] getVisibleAnnotations(Field f) throws Exception {
        CtField ctField = ReflectToJavassist.fieldToJavassist(f);
        if (ctField == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        FieldInfo fi = ctField.getFieldInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)fi.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        return AnnotationElement.getVisibleAnnotations(visible);
    }

    public static Object[] getVisibleAnnotations(Constructor c) throws Exception {
        CtConstructor ctConstructor = ReflectToJavassist.constructorToJavassist(c);
        if (ctConstructor == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        MethodInfo ci = ctConstructor.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)ci.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        return AnnotationElement.getVisibleAnnotations(visible);
    }

    private static Object[] getVisibleAnnotations(AnnotationsAttribute visible) throws Exception {
        Annotation[] annotations = visible.getAnnotations();
        Object[] returnedAnnotations = new Object[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            String name = annotations[i].getTypeName();
            Class<?> annotation = Thread.currentThread().getContextClassLoader().loadClass(name);
            returnedAnnotations[i] = AnnotationElement.create(visible, annotation);
        }
        return returnedAnnotations;
    }
}

