/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.jboss.annotation.ejb.Clustered;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.stateless.BaseStatelessProxyFactory;
import org.jboss.ejb3.stateless.StatelessClusteredProxy;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ejb3.stateless.StatelessHandleImpl;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.interfaces.RandomRobin;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.remoting.InvokerLocator;

public class StatelessClusterProxyFactory
extends BaseStatelessProxyFactory
implements RemoteProxyFactory {
    private RemoteBinding binding;
    private InvokerLocator locator;
    private HATarget hatarget;
    private String proxyFamilyName;
    private LoadBalancePolicy lbPolicy;
    private FamilyWrapper wrapper;

    public void setRemoteBinding(RemoteBinding binding) {
        this.binding = binding;
    }

    protected Class[] getInterfaces() {
        Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteInterfaces(this.container);
        Class[] interfaces = new Class[remoteInterfaces.length + 1];
        System.arraycopy(remoteInterfaces, 0, interfaces, 0, remoteInterfaces.length);
        interfaces[remoteInterfaces.length] = JBossProxy.class;
        return interfaces;
    }

    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getRemoteJndiName(this.container, this.binding);
    }

    public void start() throws Exception {
        String clientBindUrl = this.binding.clientBindUrl();
        this.locator = new InvokerLocator(clientBindUrl);
        Clustered clustered = (Clustered)this.advisor.resolveAnnotation(Clustered.class);
        if (clustered == null) {
            throw new RuntimeException("Could not find @Clustered annotation.  Cannot deploy.");
        }
        String partitionName = clustered.partition();
        this.proxyFamilyName = this.container.getEjbName() + this.locator.getProtocol() + partitionName;
        HAPartition partition = (HAPartition)this.container.getInitialContext().lookup("/HAPartition/" + partitionName);
        this.hatarget = new HATarget(partition, this.proxyFamilyName, (Serializable)this.locator, 2);
        ClusteringTargetsRepository.initTarget((String)this.proxyFamilyName, (ArrayList)this.hatarget.getReplicants());
        ((StatelessContainer)this.container).getClusterFamilies().put(this.proxyFamilyName, this.hatarget);
        this.lbPolicy = clustered.loadBalancePolicy() == null || clustered.loadBalancePolicy().equals(LoadBalancePolicy.class) ? new RandomRobin() : (LoadBalancePolicy)clustered.loadBalancePolicy().newInstance();
        this.wrapper = new FamilyWrapper(this.proxyFamilyName, this.hatarget.getReplicants());
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.hatarget.destroy();
        ((StatelessContainer)this.container).getClusterFamilies().remove(this.proxyFamilyName);
    }

    public Object createProxy() {
        try {
            String containerId = this.container.getObjectName().getCanonicalName();
            String stackName = "ClusteredStatelessSessionClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
            Object[] args = new Object[]{new StatelessClusteredProxy(containerId, stack.createInterceptors((Advisor)this.container, null), this.wrapper, this.lbPolicy)};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    protected StatelessHandleImpl getHandle() {
        StatelessHandleImpl handle = new StatelessHandleImpl();
        RemoteBinding remoteBinding = (RemoteBinding)this.advisor.resolveAnnotation(RemoteBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }
}

