/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.ejb3.EJB3DeployerMBean;
import org.jboss.ejb3.Ejb3Module;
import org.jboss.ejb3.ThreadLocalENCFactory;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameConverter;
import org.jboss.system.ServiceControllerMBean;

public class EJB3Deployer
extends SubDeployerSupport
implements SubDeployer,
EJB3DeployerMBean {
    private ServiceControllerMBean serviceController;
    private HashMap deployments = new HashMap();
    private SubDeployer thisProxy;
    private Properties DefaultProperties;

    public EJB3Deployer() {
        this.setSuffixes(new String[]{".ejb3", ".par"});
        this.setRelativeOrder(450);
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.getFile();
        if (urlStr.endsWith(".ejb3") || urlStr.endsWith(".ejb3/") || urlStr.endsWith(".par") || urlStr.endsWith(".par/")) {
            return true;
        }
        if (!urlStr.endsWith(".jar") && !urlStr.endsWith(".jar/")) {
            return false;
        }
        boolean accepts = false;
        try {
            String ddStr;
            URL dd = di.localCl.findResource("META-INF/persistence.xml");
            if (dd == null) {
                return false;
            }
            if (di.localUrl != null) {
                urlStr = di.localUrl.toString();
            }
            if ((ddStr = dd.toString()).indexOf(urlStr) >= 0) {
                accepts = true;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return accepts;
    }

    public Properties getDefaultProperties() {
        return this.DefaultProperties;
    }

    protected void startService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.thisProxy = (SubDeployer)MBeanProxyExt.create(SubDeployer.class, (ObjectName)super.getServiceName(), (MBeanServer)super.getServer());
        this.mainDeployer.addDeployer(this.thisProxy);
        InitialContext iniCtx = new InitialContext();
        EJB3Deployer.initializeJavaComp(iniCtx);
        URL propsUrl = this.getClass().getClassLoader().getResource("META-INF/persistence.properties");
        this.DefaultProperties = new Properties();
        this.DefaultProperties.load(propsUrl.openStream());
        this.log.info((Object)("Default persistence.properties: " + this.DefaultProperties));
    }

    public static void initializeJavaComp(InitialContext iniCtx) throws NamingException {
        StringRefAddr refAddr = new StringRefAddr("nns", "ENC-EJB3");
        Reference envRef = new Reference("javax.naming.Context", refAddr, ThreadLocalENCFactory.class.getName(), null);
        Context ctx = (Context)iniCtx.lookup("java:");
        ctx.rebind("comp.ejb3", (Object)envRef);
    }

    protected void stopService() throws Exception {
        for (DeploymentInfo di : this.deployments.values()) {
            this.stop(di);
        }
        for (DeploymentInfo di : new ArrayList(this.deployments.values())) {
            this.destroy(di);
        }
        this.deployments.clear();
        this.mainDeployer.removeDeployer(this.thisProxy);
        this.serviceController = null;
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("init, " + di.shortName));
        super.init(di);
    }

    public synchronized void create(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("create, " + di.shortName));
        try {
            URL loaderURL = di.localUrl != null ? di.localUrl : di.url;
            di.annotationsCl = new URLClassLoader(new URL[]{loaderURL}, (ClassLoader)di.ucl);
            Ejb3Module ejbModule = new Ejb3Module(di);
            String name = "jboss.j2ee:service=EJB3,module=" + di.shortName;
            ObjectName ejbModuleName = ObjectNameConverter.convert((String)name);
            if (this.server.isRegistered(ejbModuleName)) {
                this.log.debug((Object)("The EJBModule name: " + ejbModuleName + "is already registered, adding uid=" + System.identityHashCode(ejbModule)));
                name = name + ",uid=" + System.identityHashCode(ejbModule);
                ejbModuleName = ObjectNameConverter.convert((String)name);
            }
            this.server.registerMBean(ejbModule, ejbModuleName);
            di.deployedObject = ejbModuleName;
            this.log.debug((Object)("Deploying: " + di.url));
            this.serviceController.create(di.deployedObject);
        }
        catch (Exception e) {
            throw new DeploymentException("Error during create of EjbModule: " + di.url, (Throwable)e);
        }
        super.create(di);
    }

    public synchronized void start(DeploymentInfo di) throws DeploymentException {
        try {
            this.log.debug((Object)("start application, deploymentInfo: " + di + ", short name: " + di.shortName + ", parent short name: " + (di.parent == null ? "null" : di.parent.shortName)));
            this.serviceController.start(di.deployedObject);
            this.log.info((Object)("Deployed: " + di.url));
            this.deployments.put(di.url, di);
        }
        catch (Exception e) {
            this.stop(di);
            this.destroy(di);
            throw new DeploymentException("Could not deploy " + di.url, (Throwable)e);
        }
        super.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("init, " + di.shortName));
        try {
            this.serviceController.stop(di.deployedObject);
        }
        catch (Exception e) {
            throw new DeploymentException("problem stopping ejb module: " + di.url, (Throwable)e);
        }
        super.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        this.deployments.remove(di.url);
        try {
            this.serviceController.destroy(di.deployedObject);
            this.serviceController.remove(di.deployedObject);
        }
        catch (Exception e) {
            throw new DeploymentException("problem destroying ejb module: " + di.url, (Throwable)e);
        }
        super.destroy(di);
    }
}

