.\"
.\" $Id: Xft.3.in,v 1.2 2003/04/25 16:11:35 keithp Exp $
.\"
.\" Copyright © 2000 Keith Packard
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Keith Packard not be used in
.\" advertising or publicity pertaining to distribution of the software without
.\" specific, written prior permission.  Keith Packard makes no
.\" representations about the suitability of this software for any purpose.  It
.\" is provided "as is" without express or implied warranty.
.\"
.\" KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.de TQ
.br
.ns
.TP \\$1
..
.TH XFT 3 "Version 2.1.2" "Xft"

.SH NAME
 Xft \- X FreeType interface library

.SH DESCRIPTION
.B Xft
is a simple library designed to interface the FreeType rasterizer with the X
Rendering Extension.  This manual page barely scratches the surface of this
library.

.SH DATATYPES

.B XftPattern
holds a set of names with associated value lists; each name refers to a
property of a font.  XftPatterns are used as inputs to the matching code as
well as holding information about specific fonts.

.B XftFont
contains general font metrics and a pointer to either the core XFontStruct
data or a structure holding FreeType and X Render Extension data.

.B XftFontStruct
contains information about FreeType fonts used with the X Render Extension.

.B XftFontSet
contains a list of XftPatterns.  Internally Xft uses this data structure to
hold sets of fonts.  Externally, Xft returns the results of listing fonts in
this format.

.B XftObjectSet
holds a set of names and is used to specify which fields from fonts are
placed in the the list of returned patterns when listing fonts.

.B XftDraw
is an opaque object which holds information used to render to an X drawable
using either core protocol or the X Rendering extension.

.SH FUNCTIONS
.nf
XftFont *
XftFontOpen (Display *dpy, int screen, ...);
.fi
.B XftFontOpen
takes a list of pattern elements of the form (field, type, value) terminated
with a NULL, matches that pattern against the available fonts and opens the
matching font.
.PP
Example:
.br
	font = XftFontOpen (dpy, scr,
			    XFT_FAMILY, XftTypeString, "charter",
			    XFT_SIZE, XftTypeDouble, 12.0,
			    NULL);
.PP
This opens the charter font at 12 points.  The point size is automatically
converted to the correct pixel size based on the resolution of the monitor.
.PP
.nf
void
XftTextExtents8 (Display	*dpy,
		 XftFont	*font,
		 unsigned char  *string, 
		 int		len,
		 XGlyphInfo	*extents);
.fi
.B XftTextExtents8
computes the pixel extents of "string" when drawn with "font".
.PP
.nf
XftDraw *
XftDrawCreate (Display   *dpy,
	       Drawable  drawable,
	       Visual    *visual,
	       Colormap  colormap);
.fi
.B XftDrawCreate
creates a structure that can be used to render text and rectangles
to the screen.
.PP
.nf
void
XftDrawString8 (XftDraw		*d,
		XRenderColor	*color,
		XftFont		*font,
		int		x, 
		int		y,
		unsigned char	*string,
		int		len);
.fi
.B XftDrawString8
draws "string" using "font" in "color" at "x, y".
.PP
.nf
void
XftDrawRect (XftDraw	    *d,
	     XRenderColor   *color,
	     int	    x, 
	     int	    y,
	     unsigned int   width,
	     unsigned int   height);
.fi
.B XftDrawRect
fills a solid rectangle in the specified color.

.SH COMPATIBILITY
As of version 2, 
.B Xft
has become relatively stable and is expected to retain source and binary
compatibility in future releases.

.SH AUTHOR
Keith Packard, member of the XFree86 Project, Inc.
