#############################################################
#
# pppd
#
#############################################################
ifneq ($(USE_CVS),true)
PPPD_SOURCE:=ppp.tar.gz
PPPD_SITE:=ftp://ftp.samba.org/pub/ppp
PPPD_CAT:=zcat
endif

PPPD_DIR:=$(BUILD_DIR)/ppp
PPPD_BINARY:=pppd/pppd
PPPD_TARGET_BINARY:=usr/sbin/pppd

ifneq ($(USE_CVS),true)
pppd-fetch:
	 $(WGET) -P $(DL_DIR) $(PPPD_SITE)/$(PPPD_SOURCE)

pppd-source: $(DL_DIR)/$(PPPD_SOURCE)
endif

PPPD_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d ppp $(CVS_TAG) $(CVS_PREFIX)ppp

pppd-checkout:
	@$(PPPD_CVSCO)

$(PPPD_DIR)/.unpacked: $(DL_DIR)/$(PPPD_SOURCE)
ifneq ($(USE_CVS),true)
	$(PPPD_CAT) $(DL_DIR)/$(PPPD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PPPD_CVSCO)
endif
	sed -i -e 's/ -DIPX_CHANGE -DHAVE_MULTILINK -DHAVE_MMAP//' \
		-e 's,^#USE_PAM=y,USE_PAM=y,' \
		$(PPPD_DIR)/pppd/Makefile.linux
	sed -i -e 's/$(INSTALL) -s/$(INSTALL)/' $(PPPD_DIR)/*/Makefile.linux
	sed -i -e 's/ -o root//' $(PPPD_DIR)/*/Makefile.linux
	sed -i -e 's/ -g daemon//' $(PPPD_DIR)/*/Makefile.linux
	sed -i -e 's,<net/bpf\.h>,<pcap-bpf.h>,g' $(PPPD_DIR)/pppd/*.c
	touch $(PPPD_DIR)/.unpacked

$(PPPD_DIR)/.configured: $(PPPD_DIR)/.unpacked
	(cd $(PPPD_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(PPPD_DIR)/.configured

$(PPPD_DIR)/$(PPPD_BINARY): $(PPPD_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(PPPD_DIR)

$(STAGING_DIR)/usr/include/ppp: $(PPPD_DIR)/$(PPPD_BINARY)
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(PPPD_DIR) install-devel

$(TARGET_DIR)/$(PPPD_TARGET_BINARY): $(STAGING_DIR)/usr/include/ppp
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(PPPD_DIR) install
	rm -rf $(TARGET_DIR)/usr/include/ppp
	$(STRIP) $(TARGET_DIR)/usr/sbin/pppd \
		$(TARGET_DIR)/usr/sbin/chat
	install -m0644 $(PPPD_DIR)/pppd/ppp.pam $(TARGET_DIR)/etc/pam.d/ppp
	install -d $(DOC_DIR)/doc/ppp
	for f in FAQ SETUP `find $(PPPD_DIR) -maxdepth 1 -name README\*` ; do \
		SRC=$(PPPD_DIR)/`echo $$f | sed "s,^$(PPPD_DIR),,"` ;\
		install -m0644 $$SRC $(DOC_DIR)/doc/ppp/`basename $$f` ;\
	done

pppd: uclibc tcpdump libpcap $(TARGET_DIR)/$(PPPD_TARGET_BINARY)

ppp: pppd

pppd-clean:
	-rm -f  $(TARGET_DIR)/usr/sbin/pppd
	-rm -f  $(TARGET_DIR)/usr/sbin/chat \
		$(TARGET_DIR)/etc/pam.d/ppp
	-rm -rf $(TARGET_DIR)/etc/ppp
	-rm -rf $(STAGING_DIR)/usr/include/ppp
	-rm -rf $(DOC_DIR)/doc/ppp
	# this target doesn't exist
	#-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(PPPD_DIR) uninstall
	-$(MAKE) -C $(PPPD_DIR) clean

pppd-dirclean:
	rm -rf $(PPPD_DIR)


