#############################################################
#
# kernel-frv
#
#############################################################
ifneq ($(USE_CVS), true)
KERNEL_FRV_SOURCE:=kernel-frv.tar.gz
KERNEL_FRV_DIR:=$(BUILD_DIR)/kernel-frv
KERNEL_FRV_CAT:=zcat
else
KERNEL_FRV_DIR:=$(BUILD_DIR)/kernel-frv
endif

KERNEL_FRV_HEADER:=include/linux/version.h

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(KERNEL_FRV_SOURCE):
kernel-frv-source: $(DL_DIR)/$(KERNEL_FRV_SOURCE)
else
kernel-frv-source:
endif

ifneq ($(USE_CVS), true)
$(KERNEL_FRV_DIR)/.unpacked: $(DL_DIR)/$(KERNEL_FRV_SOURCE)
	$(KERNEL_FRV_CAT) $(DL_DIR)/$(KERNEL_FRV_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
$(KERNEL_FRV_DIR)/.unpacked:
	cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d kernel-frv -r uc-040210-frv-devel-branch $(CVS_PREFIX)uClinux/linux-2.4.x
endif
	-cat $(SOURCE_DIR)/kernel-frv.patch | patch -d $(KERNEL_FRV_DIR)
	touch  $(KERNEL_FRV_DIR)/.unpacked

$(KERNEL_FRV_DIR)/.configured: $(KERNEL_FRV_DIR)/.unpacked
	(cd $(KERNEL_FRV_DIR); \
		rm -rf .config; \
		$(MAKE) mrproper; \
		cp arch/frv/defconfig-mmu .config; \
		$(MAKE) oldconfig; \
		$(MAKE) dep; \
	);
	touch $(KERNEL_FRV_DIR)/.configured

$(KERNEL_FRV_DIR)/$(KERNEL_FRV_HEADER): $(KERNEL_FRV_DIR)/.configured
	echo "nothing to do here"

kernel-frv: $(KERNEL_FRV_DIR)/$(KERNEL_FRV_HEADER)

kernel-frv-clean:
	-$(MAKE) -C $(KERNEL_FRV_DIR) clean

kernel-frv-dirclean:
	rm -rf $(KERNEL_FRV_DIR)

