#############################################################
#
# gettext
#
#############################################################
# only for uclibc build
ifneq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
GETTEXT_SOURCE:=gettext.tar.gz
GETTEXT_SITE:=ftp://ftp.gnu.org/gnu/gettext
GETTEXT_CAT:=zcat
endif

GETTEXT_DIR:=$(BUILD_DIR)/gettext
GETTEXT_BINARY:=libgettextlib.so
GETTEXT_TARGET_BINARY:=usr/lib/libgettextlib.so

ifneq ($(USE_CVS),true)
gettext-fetch:
	 $(WGET) -P $(DL_DIR) $(GETTEXT_SITE)/$(GETTEXT_SOURCE)

gettext-source: $(DL_DIR)/$(GETTEXT_SOURCE)
else
gettext-source:
endif

GETTEXT_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d gettext $(CVS_TAG) $(CVS_PREFIX)gettext

gettext-checkout:
	@$(GETTEXT_CVSCO)

$(GETTEXT_DIR)/.unpacked: $(DL_DIR)/$(GETTEXT_SOURCE)
ifneq ($(USE_CVS),true)
	$(GETTEXT_CAT) $(DL_DIR)/$(GETTEXT_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(GETTEXT_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(GETTEXT_DIR)/
	touch $(GETTEXT_DIR)/.unpacked

$(GETTEXT_DIR)/.configured: $(GETTEXT_DIR)/.unpacked
	(cd $(GETTEXT_DIR); rm -rf config.cache; \
		find . -name configure.ac | xargs touch; \
		find . -name aclocal.m4 | xargs touch; \
		find . -name Makefile.am | xargs touch; \
		find . -name Makefile.in | xargs touch; \
		ac_cv_linux_vers=2 \
		nls_cv_use_gnu_gettext=yes \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--with-included-gettext \
		--with-pcap=linux \
		--disable-csharp \
	);
	touch  $(GETTEXT_DIR)/.configured

$(GETTEXT_DIR)/gettext-tools/lib/.libs/$(GETTEXT_BINARY): $(GETTEXT_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(GETTEXT_DIR)

$(STAGING_DIR)/$(GETTEXT_TARGET_BINARY): $(GETTEXT_DIR)/gettext-tools/lib/.libs/$(GETTEXT_BINARY)
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(GETTEXT_DIR) install
	install -d $(DOC_DIR)/doc/gettext
	@for f in README ; do \
		install -m0644 $(GETTEXT_DIR)/$$f $(DOC_DIR)/doc/gettext/$$f ;\
	done

$(TARGET_DIR)/$(GETTEXT_TARGET_BINARY): $(STAGING_DIR)/$(GETTEXT_TARGET_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(GETTEXT_DIR) install
	install -d $(DOC_DIR)/doc/gettext
	@for f in README ; do \
		install -m0644 $(GETTEXT_DIR)/$$f $(DOC_DIR)/doc/gettext/$$f ;\
	done

gettext: uclibc $(TARGET_DIR)/$(GETTEXT_TARGET_BINARY)

gettext-clean:
	-$(MAKE) DESTDIR=$(STAGING_DIR) -C $(GETTEXT_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/gettext
	-$(MAKE) -C $(GETTEXT_DIR) clean

gettext-dirclean:
	rm -rf $(GETTEXT_DIR)
endif

