#############################################################
#
# fontconfig
#
#############################################################
ifneq ($(USE_CVS),true)
FONTCONFIG_SOURCE:=fontconfig.tar.gz
FONTCONFIG_SITE:=xxxxxxxxxxxxxxxxxxxxxxxx
FONTCONFIG_CAT:=zcat
endif

FONTCONFIG_DIR=$(BUILD_DIR)/fontconfig

ifneq ($(USE_CVS),true)
fontconfig-fetch:
	 $(WGET) -P $(DL_DIR) $(FONTCONFIG_SITE)/$(FONTCONFIG_SOURCE)

fontconfig-source: $(DL_DIR)/$(FONTCONFIG_SOURCE)
else
fontconfig-source:
endif

FONTCONFIG_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d fontconfig $(CVS_TAG) $(CVS_PREFIX)fontconfig

fontconfig-checkout:
	@$(FONTCONFIG_CVSCO)

$(FONTCONFIG_DIR)/.unpacked: $(DL_DIR)/$(FONTCONFIG_SOURCE)
ifneq ($(USE_CVS),true)
	$(FONTCONFIG_CAT) $(DL_DIR)/$(FONTCONFIG_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(FONTCONFIG_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(FONTCONFIG_DIR)/
	touch $(FONTCONFIG_DIR)/.unpacked

$(FONTCONFIG_DIR)/.configured: $(FONTCONFIG_DIR)/.unpacked
	(cd $(FONTCONFIG_DIR); rm -rf config.cache; automake -a; autoconf; \
		EGREP=egrep \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS) -I$(TARGET_DIR)/usr/include" \
		LDFLAGS="-L$(TARGET_DIR)/usr/lib" \
		ac_cv_header_xmlparse_h=$(STAGING_DIR)/usr/include/w3c-libwww/xmlparse.h \
		ac_cv_header_expat_h=$(STAGING_DIR)/usr/include/expat.h \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--with-expat \
		--with-expat-lib=$(STAGING_DIR)/usr/lib/ \
		--with-expat-include=$(STAGING_DIR)/usr/include \
	);
	touch  $(FONTCONFIG_DIR)/.configured

$(FONTCONFIG_DIR)/src/.libs/libfontconfig.so: $(FONTCONFIG_DIR)/.configured
	$(MAKE) EGREP=egrep \
		LDFLAGS="-L$(STAGING_DIR)/usr/lib -L$(STAGING_DIR)/lib" \
		FREETYPE_LIBS="-lfreetype -lz" \
		CC_FOR_BUILD=$(HOSTCC) -C $(FONTCONFIG_DIR)


$(STAGING_DIR)/usr/lib/libfontconfig.so: $(FONTCONFIG_DIR)/src/.libs/libfontconfig.so
	$(MAKE) \
	    EGREP=egrep \
	    CC_FOR_BUILD=$(HOSTCC)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/fontconfig \
	    -C $(FONTCONFIG_DIR) install-strip;
	chmod a-x $(STAGING_DIR)/usr/lib/libfontconfig*so*
	rm -f $(STAGING_DIR)/usr/lib/libfontconfig.la

$(TARGET_DIR)/usr/lib/libfontconfig.so: $(STAGING_DIR)/usr/lib/libfontconfig.so
	$(MAKE) \
	    EGREP=egrep \
	    CC_FOR_BUILD=$(HOSTCC)  \
	    prefix=$(STAGING_DIR) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/fontconfig \
	    -C $(FONTCONFIG_DIR) install-strip;
	chmod a-x $(TARGET_DIR)/usr/lib/libfontconfig*so*
	rm -f $(TARGET_DIR)/usr/lib/libfontconfig.la
	mkdir -p $(DOC_DIR)/doc/fontconfig
	@for f in COPYING README ; do \
		install -m0644 -D $(FONTCONFIG_DIR)/$$f $(DOC_DIR)/doc/fontconfig/$$f ;\
	done

fontconfig-clean:
	-$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/fontconfig \
	    -C $(FONTCONFIG_DIR) uninstall
	-$(MAKE)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/fontconfig \
	    -C $(FONTCONFIG_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/fontconfig
	$(MAKE) -C $(FONTCONFIG_DIR) clean

fontconfig-dirclean:
	rm -rf $(FONTCONFIG_DIR)

fontconfig: uclibc $(TARGET_DIR)/usr/lib/libfontconfig.so


