#############################################################
#
# expat
#
#############################################################
ifneq ($(USE_CVS),true)
EXPAT_SOURCE:=expat.tar.gz
EXPAT_SITE:=xxxxxxxxxxxxxxxxxxxxxxxx
EXPAT_CAT:=zcat
endif

EXPAT_DIR:=$(BUILD_DIR)/expat

ifneq ($(USE_CVS),true)
expat-fetch:
	 $(WGET) -P $(DL_DIR) $(EXPAT_SITE)/$(EXPAT_SOURCE)

expat-source: $(DL_DIR)/$(EXPAT_SOURCE)
else
expat-source:
endif

EXPAT_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d expat $(CVS_TAG) $(CVS_PREFIX)expat

expat-checkout:
	@$(EXPAT_CVSCO)

$(EXPAT_DIR)/.unpacked: $(DL_DIR)/$(EXPAT_SOURCE)
ifneq ($(USE_CVS),true)
	$(EXPAT_CAT) $(DL_DIR)/$(EXPAT_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(EXPAT_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(EXPAT_DIR)/
	touch $(EXPAT_DIR)/.unpacked

$(EXPAT_DIR)/.configured: $(EXPAT_DIR)/.unpacked
	(cd $(EXPAT_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS) -I$(STAGING_DIR)/usr/include" \
		LDFLAGS="-L$(STAGING_DIR)/usr/lib" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
	);
	touch  $(EXPAT_DIR)/.configured

$(EXPAT_DIR)/.libs/libexpat.so: $(EXPAT_DIR)/.configured
	$(MAKE) -C $(EXPAT_DIR)

$(STAGING_DIR)/usr/lib/libexpat.so: $(EXPAT_DIR)/.libs/libexpat.so
	$(MAKE) \
	    bindir=$(STAGING_DIR)/usr/bin mandir=$(STAGING_DIR)/usr/man/man1 \
	    libdir=$(STAGING_DIR)/usr/lib includedir=$(STAGING_DIR)/usr/include \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/expat \
	    -C $(EXPAT_DIR) install;
	chmod a-x $(STAGING_DIR)/usr/lib/libexpat*so*
	rm -f $(STAGING_DIR)/usr/lib/libexpat.la


$(TARGET_DIR)/usr/lib/libexpat.so: $(STAGING_DIR)/usr/lib/libexpat.so
	$(MAKE) \
	    bindir=$(TARGET_DIR)/usr/bin mandir=$(TARGET_DIR)/usr/man/man1 \
	    libdir=$(TARGET_DIR)/usr/lib includedir=$(TARGET_DIR)/usr/include \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/expat \
	    -C $(EXPAT_DIR) install;
	chmod a-x $(TARGET_DIR)/usr/lib/libexpat*so*
	mkdir -p $(DOC_DIR)/doc/expat
	@for f in COPYING README ; do \
		install -m0644 $(EXPAT_DIR)/$$f $(DOC_DIR)/doc/expat/$$f ;\
	done
	rm -f $(TARGET_DIR)/usr/lib/libexpat.la

expat-clean:
	-$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/expat \
	    -C $(EXPAT_DIR) uninstall
	-$(MAKE)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/expat \
	    -C $(EXPAT_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/expat
	$(MAKE) -C $(EXPAT_DIR) clean


expat-dirclean:
	rm -rf $(EXPAT_DIR)

expat: uclibc $(TARGET_DIR)/usr/lib/libexpat.so


