#############################################################
#
# atk
#
#############################################################
ifneq ($(USE_CVS),true)
ATK_SOURCE:=atk.tar.gz
ATK_SITE:=xxxxxxxxxxxxxxxxxxxxxxxx
ATK_CAT:=zcat
endif

ATK_DIR:=$(BUILD_DIR)/atk

ifneq ($(USE_CVS),true)
atk-fetch:
	 $(WGET) -P $(DL_DIR) $(ATK_SITE)/$(ATK_SOURCE)

atk-source: $(DL_DIR)/$(ATK_SOURCE)
else
atk-source:
endif

ATK_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d atk $(CVS_TAG) $(CVS_PREFIX)atk

atk-checkout:
	@$(ATK_CVSCO)

$(ATK_DIR)/.unpacked: $(DL_DIR)/$(ATK_SOURCE)
ifneq ($(USE_CVS),true)
	$(ATK_CAT) $(DL_DIR)/$(ATK_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(ATK_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(ATK_DIR)/
	touch $(ATK_DIR)/.unpacked

$(ATK_DIR)/.configured: $(ATK_DIR)/.unpacked
	(cd $(ATK_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--disable-gtk-doc \
	);
	touch  $(ATK_DIR)/.configured

$(ATK_DIR)/atk/.libs/libatk-1.0.so: $(ATK_DIR)/.configured
	$(MAKE) -C $(ATK_DIR)

$(STAGING_DIR)/usr/lib/libatk-1.0.so: $(ATK_DIR)/atk/.libs/libatk-1.0.so
	$(MAKE) \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/atk \
	    -C $(ATK_DIR) install;
	chmod a-x $(STAGING_DIR)/usr/lib/libatk*so*
	rm -f $(STAGING_DIR)/usr/lib/libatk*.la

$(TARGET_DIR)/usr/lib/libatk-1.0.so: $(STAGING_DIR)/usr/lib/libatk-1.0.so
	$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/atk \
	    -C $(ATK_DIR) install
	rm -f $(TARGET_DIR)/usr/lib/libatk*.la
	mkdir -p $(DOC_DIR)/doc/atk
	for f in README ; do \
		install -m0644 $(ATK_DIR)/$$f $(DOC_DIR)/doc/atk/$$f ;\
	done


atk-clean:
	-$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/atk \
	    -C $(ATK_DIR) uninstall
	-$(MAKE)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/atk \
	    -C $(ATK_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/atk
	$(MAKE) -C $(ATK_DIR) clean


atk-dirclean:
	rm -rf $(ATK_DIR)

atk: uclibc $(TARGET_DIR)/usr/lib/libatk-1.0.so


