/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.federation;

import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.federation.FederatedRepository;
import org.jboss.dna.repository.federation.FederatedRepositorySource;
import org.jboss.dna.spi.cache.CachePolicy;
import org.jboss.dna.spi.graph.commands.GraphCommand;
import org.jboss.dna.spi.graph.connection.ExecutionEnvironment;
import org.jboss.dna.spi.graph.connection.RepositoryConnection;
import org.jboss.dna.spi.graph.connection.RepositorySourceException;
import org.jboss.dna.spi.graph.connection.RepositorySourceListener;

@ThreadSafe
public class FederatedRepositoryConnection
implements RepositoryConnection {
    protected static final RepositorySourceListener NO_OP_LISTENER = new RepositorySourceListener(){

        public void notify(String sourceName, Object ... events) {
        }
    };
    private final FederatedRepository repository;
    private final FederatedRepositorySource source;
    private RepositorySourceListener listener = NO_OP_LISTENER;

    protected FederatedRepositoryConnection(FederatedRepository repository, FederatedRepositorySource source) {
        assert (source != null);
        assert (repository != null);
        this.source = source;
        this.repository = repository;
    }

    protected FederatedRepository getRepository() {
        return this.repository;
    }

    protected FederatedRepositorySource getRepositorySource() {
        return this.source;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.repository.getDefaultCachePolicy();
    }

    public XAResource getXAResource() {
        return null;
    }

    public void setListener(RepositorySourceListener listener) {
        RepositorySourceListener oldListener = this.listener;
        this.listener = listener != null ? listener : NO_OP_LISTENER;
        this.repository.addListener(this.listener);
        if (oldListener != NO_OP_LISTENER) {
            this.repository.removeListener(oldListener);
        }
    }

    public boolean ping(long time, TimeUnit unit) {
        return this.repository.getAdministrator().isStarted();
    }

    public void execute(ExecutionEnvironment env, GraphCommand ... commands) throws RepositorySourceException {
        if (!this.repository.getAdministrator().isStarted()) {
            throw new RepositorySourceException(RepositoryI18n.repositoryHasBeenShutDown.text(new Object[]{this.repository.getName()}));
        }
        if (commands == null || commands.length == 0) {
            return;
        }
        for (GraphCommand command : commands) {
            if (command != null) continue;
        }
    }

    public void close() {
        this.repository.removeListener(this.listener);
    }
}

