/*
 * Copyright 2005 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.event;

import java.util.EventObject;

import org.drools.WorkingMemory;
import org.drools.spi.PropagationContext;

public class WorkingMemoryEvent extends EventObject {
    private static final long        serialVersionUID = 510l;
    private final PropagationContext propagationContext;

    public WorkingMemoryEvent(final WorkingMemory workingMemory,
                              final PropagationContext propagationContext) {
        super( workingMemory );
        this.propagationContext = propagationContext;
    }

    public WorkingMemory getWorkingMemory() {
        return (WorkingMemory) getSource();
    }

    public PropagationContext getPropagationContext() {
        return this.propagationContext;
    }
}
