/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.dna.common.util.CheckArg;

public class FileUtil {
    public static boolean delete(String path) {
        if (path == null || path.trim().length() == 0) {
            return false;
        }
        return FileUtil.delete(new File(path));
    }

    public static boolean delete(File fileOrDirectory) {
        if (fileOrDirectory == null) {
            return false;
        }
        if (!fileOrDirectory.exists()) {
            return false;
        }
        if (fileOrDirectory.isDirectory()) {
            for (File childFile : fileOrDirectory.listFiles()) {
                FileUtil.delete(childFile);
            }
        }
        return fileOrDirectory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File sourceFileOrDirectory, File destinationFileOrDirectory) throws IOException {
        int numberOfFilesCopied = 0;
        if (sourceFileOrDirectory.isDirectory()) {
            destinationFileOrDirectory.mkdirs();
            String[] list = sourceFileOrDirectory.list();
            for (int i = 0; i < list.length; ++i) {
                String dest1 = destinationFileOrDirectory.getPath() + File.separator + list[i];
                String src1 = sourceFileOrDirectory.getPath() + File.separator + list[i];
                numberOfFilesCopied += FileUtil.copy(new File(src1), new File(dest1));
            }
        } else {
            InputStream fin = new FileInputStream(sourceFileOrDirectory);
            fin = new BufferedInputStream(fin);
            try {
                OutputStream fout = new FileOutputStream(destinationFileOrDirectory);
                fout = new BufferedOutputStream(fout);
                try {
                    int c;
                    while ((c = fin.read()) >= 0) {
                        fout.write(c);
                    }
                }
                finally {
                    fout.close();
                }
            }
            finally {
                fin.close();
            }
            ++numberOfFilesCopied;
        }
        return numberOfFilesCopied;
    }

    public static URL convertFileToURL(String filePath) throws MalformedURLException {
        CheckArg.isNotEmpty(filePath, "filePath");
        File file = new File(filePath.trim());
        return file.toURI().toURL();
    }
}

