/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.federation;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.federation.FederatedSource;
import org.jboss.dna.repository.federation.FederationService;
import org.jboss.dna.repository.services.AbstractServiceAdministrator;
import org.jboss.dna.repository.services.ServiceAdministrator;
import org.jboss.dna.spi.cache.CachePolicy;
import org.jboss.dna.spi.graph.connection.RepositoryConnectionPool;
import org.jboss.dna.spi.graph.connection.RepositorySourceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class FederatedRepository {
    private final ServiceAdministrator administrator = new Administrator();
    private final String name;
    private final FederationService service;
    private final Lock sourcesWriteLock = new ReentrantLock();
    private final List<FederatedSource> sources = new CopyOnWriteArrayList<FederatedSource>();
    private final CopyOnWriteArrayList<RepositorySourceListener> listeners = new CopyOnWriteArrayList();
    private CachePolicy defaultCachePolicy;

    public FederatedRepository(FederationService service, String name) {
        ArgCheck.isNotNull((Object)service, (String)"service");
        ArgCheck.isNotEmpty((String)name, (String)"name");
        this.name = name;
        this.service = service;
    }

    protected FederationService getService() {
        return this.service;
    }

    public String getName() {
        return this.name;
    }

    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    protected void startRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownRepository() {
        try {
            this.sourcesWriteLock.lock();
            for (FederatedSource source : this.sources) {
                source.getConnectionPool().shutdown();
            }
        }
        finally {
            this.sourcesWriteLock.unlock();
        }
        this.service.removeRepository(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.sourcesWriteLock.lock();
            for (FederatedSource source : this.sources) {
                if (source.getConnectionPool().awaitTermination(timeout, unit)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminating() {
        try {
            this.sourcesWriteLock.lock();
            for (FederatedSource source : this.sources) {
                if (!source.getConnectionPool().isTerminating()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.sourcesWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        try {
            this.sourcesWriteLock.lock();
            for (FederatedSource source : this.sources) {
                if (source.getConnectionPool().isTerminated()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesWriteLock.unlock();
        }
    }

    public List<FederatedSource> getSources() {
        return Collections.unmodifiableList(this.sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSource(FederatedSource source) {
        if (source == null) {
            return false;
        }
        try {
            this.sourcesWriteLock.lock();
            for (FederatedSource existingSource : this.sources) {
                if (!existingSource.getName().equals(source.getName())) continue;
                boolean bl = false;
                return bl;
            }
            this.sources.add(source);
        }
        finally {
            this.sourcesWriteLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSource(FederatedSource source, int index) {
        if (source == null) {
            return false;
        }
        try {
            this.sourcesWriteLock.lock();
            for (FederatedSource existingSource : this.sources) {
                if (!existingSource.getName().equals(source.getName())) continue;
                boolean bl = false;
                return bl;
            }
            this.sources.add(index, source);
        }
        finally {
            this.sourcesWriteLock.unlock();
        }
        return true;
    }

    public boolean removeSource(FederatedSource source, long timeToAwait, TimeUnit unit) throws InterruptedException {
        return this.removeSource(source.getName(), timeToAwait, unit) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FederatedSource removeSource(String name, long timeToAwait, TimeUnit unit) throws InterruptedException {
        try {
            this.sourcesWriteLock.lock();
            for (FederatedSource existingSource : this.sources) {
                if (!existingSource.getName().equals(name)) continue;
                boolean removed = this.sources.remove(existingSource);
                assert (removed);
                RepositoryConnectionPool pool = existingSource.getConnectionPool();
                pool.shutdown();
                if (timeToAwait > 0L) {
                    pool.awaitTermination(timeToAwait, unit);
                }
                FederatedSource federatedSource = existingSource;
                return federatedSource;
            }
        }
        finally {
            this.sourcesWriteLock.unlock();
        }
        return null;
    }

    public boolean addListener(RepositorySourceListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.addIfAbsent(listener);
    }

    public boolean removeListener(RepositorySourceListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.remove(listener);
    }

    public List<RepositorySourceListener> getListeners() {
        return this.listeners;
    }

    public boolean authenticate(String username, Object credentials) {
        return true;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public void setDefaultCachePolicy(CachePolicy defaultCachePolicy) {
        ArgCheck.isNotNull((Object)defaultCachePolicy, (String)"defaultCachePolicy");
        this.defaultCachePolicy = defaultCachePolicy;
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.federationServiceName, ServiceAdministrator.State.STARTED);
        }

        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            FederatedRepository.this.startRepository();
        }

        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            FederatedRepository.this.shutdownRepository();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return FederatedRepository.this.awaitTermination(timeout, unit);
        }

        protected boolean doCheckIsTerminated() {
            return FederatedRepository.this.isTerminated();
        }
    }
}

