#include <fcntl.h>

#include "locks.h"

int lockfile(int fd)
{
    struct flock lockinfo;

    lockinfo.l_type = F_WRLCK;
    lockinfo.l_whence = 0;
    lockinfo.l_start = 0;
    lockinfo.l_len = 0;      /* 0 here means EOF */
    
    return fcntl(fd, F_SETLK, &lockinfo);
}

int unlockfile(int fd)
{
    struct flock lockinfo;

    lockinfo.l_type = F_UNLCK;
    lockinfo.l_whence = 0;
    lockinfo.l_start = 0;
    lockinfo.l_len = 0;      /* 0 here means EOF */
    
    return fcntl(fd, F_SETLK, &lockinfo);
}

