/***************************************************************************
                          kfilereplaceview.cpp  -  description
                             -------------------
    begin                : sam oct 16 15:28:00 CEST 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@lemel.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// include files for Qt
#include <qprinter.h>
#include <qpainter.h>

#include <kmsgbox.h>

// application specific includes
#include <kfilereplaceview.h>
#include "kfilereplacedoc.h"
#include "kfilereplace.h"
#include "addstringdlg.h"
#include "resource.h"

// ===========================================================================================================================
KFileReplaceView::KFileReplaceView(QWidget *parent=0,const char *name=0,Orientation orient=Vertical,Units units=Percent,int pos)
    :KNewPanner(parent,name,orient,units,pos)
{
	m_ResultList = new QListView(this,"reslist");
	m_StringsList = new QListView(this,"strlist");
}

// ===========================================================================================================================
KFileReplaceView::~KFileReplaceView()
{
	

}


// ===========================================================================================================================
KFileReplaceDoc* KFileReplaceView::getDocument() const
{
	KFileReplaceApp* theApp=(KFileReplaceApp*)parentWidget();
	return theApp->getDocument();
}

// ===========================================================================================================================
void KFileReplaceView::print(QPrinter* m_pPrinter)
{
	QPainter printpainter;
	printpainter.begin(m_pPrinter);
	
	// TODO: add your printing code here
	
	printpainter.end();

}

// ===========================================================================================================================
void KFileReplaceView::init()
{ int nRes;

	activate(m_StringsList, m_ResultList); // TopView = Strings, Bottom = Result

  // Initialize ResultList
	m_ResultList->addColumn(i18n("Name"), -1 );
	m_ResultList->setColumnWidthMode( 0, QListView::Maximum );
	m_ResultList->setColumnAlignment( 0, 1 );
	m_ResultList->addColumn(i18n("Directory"), -1 );
	m_ResultList->setColumnWidthMode( 1, QListView::Maximum );
	m_ResultList->setColumnAlignment( 1, 1 );
	m_ResultList->addColumn(i18n("Old size"), -1 );
	m_ResultList->setColumnWidthMode( 2, QListView::Maximum );
	m_ResultList->setColumnAlignment( 2, 2 );
	m_ResultList->addColumn(i18n("New Size"), -1 );
	m_ResultList->setColumnWidthMode( 3, QListView::Maximum );
	m_ResultList->setColumnAlignment( 3, 2 );
	m_ResultList->addColumn(i18n("Nb replaced"), -1 );
	m_ResultList->setColumnWidthMode( 4, QListView::Maximum );
	m_ResultList->setColumnAlignment( 4, 2 );
	m_ResultList->addColumn(i18n("Error"), -1 );
	m_ResultList->setColumnWidthMode( 5, QListView::Maximum );
	m_ResultList->setColumnAlignment( 5, 1 );
	m_ResultList->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	m_ResultList->setLineWidth(2);
	m_ResultList->setRootIsDecorated (true);

  // Initialize StringsList
	m_StringsList->addColumn(i18n("Search for"), -1 );
	m_StringsList->setColumnWidthMode( 0, QListView::Maximum );
	m_StringsList->setColumnAlignment( 0, 1 );
	m_StringsList->addColumn(i18n("Replace by"), -1 );
	m_StringsList->setColumnWidthMode( 1, QListView::Maximum );
	m_StringsList->setColumnAlignment( 1, 1 );
	m_StringsList->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	m_StringsList->setLineWidth(2);

	// Load icons
	nRes = m_pmIconSuccess.load(KApplication::kde_datadir() + "/kfilereplace/pics/success.xpm");
	nRes = m_pmIconError.load(KApplication::kde_datadir() + "/kfilereplace/pics/error.xpm");
	nRes = m_pmIconString.load(KApplication::kde_datadir() + "/kfilereplace/pics/string.xpm");

}

// ===========================================================================================================================
// BUG IN THIS FUNCTION WITH LISTVIEW WHEN USING THREADS
int KFileReplaceView::ListView_AddFullItem(bool bSuccess, char *szName, char *szDirectory, uint nOldSize, uint nNewSize, int nNbRepl, char *szErrMsg)
{ //return 0;
	QString strOldSize;
	QString strNewSize;
	QString strNbRepl;

	// Prepare text to add
	strOldSize = formatSize(nOldSize);
	strNewSize = formatSize(nNewSize);
	strNbRepl.sprintf("%ld", nNbRepl);
	

	// Add item to list
	QListViewItem *lvi;

	lvi = new QListViewItem(m_ResultList, szName, szDirectory, strOldSize.data());
	if (lvi == 0)
		return -1;

	if (bSuccess) // Success
	{	lvi -> setPixmap(0, m_pmIconSuccess);
		lvi -> setText(3, strNewSize.data());
		lvi -> setText(4, strNbRepl.data());
		lvi -> setText(5, i18n("Success"));
	}
	else // Error
	{	lvi -> setPixmap(0, m_pmIconError);
		if (szErrMsg)
			lvi -> setText(5, szErrMsg);
	}

	return 0;
}

// ===========================================================================================================================
// BUG IN THIS FUNCTION WITH LISTVIEW WHEN USING THREADS
int KFileReplaceView::ListView_UpdateItem(QListViewItem *lvi, bool bSuccess, uint nNewSize, int nNbRepl, char *szErrMsg)
{ //return 0;
	QString strNewSize;
	QString strNbRepl;

	// Prepare text to add
	strNewSize = formatSize(nNewSize);
	strNbRepl.sprintf("%ld", nNbRepl);
	
	if (bSuccess) // Success
	{	lvi -> setPixmap(0, m_pmIconSuccess);
		lvi -> setText(3, strNewSize.data());
		lvi -> setText(4, strNbRepl.data());
		lvi -> setText(5, i18n("Success"));
	}
	else // Error
	{	lvi -> setPixmap(0, m_pmIconError);
		if (szErrMsg)
			lvi -> setText(5, szErrMsg);
	}

	return 0;
}

// ===========================================================================================================================
void KFileReplaceView::slotStringAdd()
{	AddStringDlg dlg(this);
	QListViewItem *lvi;
	QListViewItem *lviCurItem;
	QListViewItem *lviFirst;
	char szMess[MAX_MESSAGE];

	if (dlg.exec() == QDialog::Rejected) // If Cancel
		return ;

	// Check item is not already in the TextList
	lviCurItem = lviFirst = getStringsList() -> firstChild();
	if (lviCurItem != NULL)
	{	do // For all strings there are in the TextList
		{	if (strcmp(dlg.m_strSearch.data(), lviCurItem -> text(0)) == 0) // Item is already in the TextList
			{	sprintf(szMess, i18n("The \"%s\" item is already present in the list."), dlg.m_strSearch.data());
				KMsgBox::message(this, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
    				return ;
			}

			lviCurItem = lviCurItem -> nextSibling();
			} while(lviCurItem && lviCurItem != lviFirst);
	}

	// Check there is not too items to replace
	if (getStringsList() -> childCount() >= MAX_STRINGSTOSEARCHREP)
	{	sprintf(szMess, i18n("Unable to have more than %ld items to search or replace."), MAX_STRINGSTOSEARCHREP );
		KMsgBox::message(this, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
		return ;
	}

	// Add string to string list	
	lvi = new QListViewItem(getStringsList());
  CHECK_PTR( lvi );
	lvi -> setPixmap(0, m_pmIconString);
	lvi -> setText(0, dlg.m_strSearch);
	lvi -> setText(1, dlg.m_strReplace);
	
}

