/***************************************************************************
                          kfilecoder.h  -  description                              
                             -------------------                                         
    begin                : lun mai  3 20:19:52 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@lemel.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KFILECODER_H
#define KFILECODER_H 
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>
#include <qlistview.h>

// include files for KDE 
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include <sys/param.h>

// application specific includes
#include "kfilecoderdoc.h"
#include "resource.h"

/**
  * This Class is the base class for your application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class KFileCoderView is
  * created which creates your view.
  */
class KFileCoderApp : public KTMainWindow 
{
  Q_OBJECT

public:
  KFileCoderApp();
  ~KFileCoderApp();
  void initMenuBar();
  void initToolBar();
  void initStatusBar();
  void initView();
  void saveOptions();
  void readOptions();
  void enableCommand(int id_);
  void disableCommand(int id_);
  bool queryExit();

	void UpdateCommandsAccess();

 public slots:
  void commandCallback(int id_);
  void statusCallback(int id_);
  void slotFileNewWindow();
  void slotFileNew();
  void slotFileOpen();
	void slotOpenRecent(int i);
  void slotFileClose();
	void slotFileProperties();
  void slotFileQuit();
  void slotArchiveAdd();
  void slotArchiveExtractAll();
  void slotArchiveExtractSel();
  void slotArchiveDelete();
  void slotViewToolBar();
  void slotViewStatusBar();
  void slotStatusMsg(const char *text);
  void slotStatusHelpMsg(const char *text);
	void closeEvent ( QCloseEvent *);


private:
  QPopupMenu *file_menu;
  QPopupMenu *extract_menu;
  QPopupMenu *archive_menu;
  QPopupMenu *view_menu;
  QPopupMenu *help_menu;
  QPopupMenu *recentPop;

	QListView *view;

  /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
  KFileCoderDoc *doc;
  /** flag if toolbar is visible or not. Used for kconfig and checking the
    * view-menu entry view toolbar. bViewStatusbar does the same for the
    * statusbar.
    */
  bool bViewToolbar;
  bool bViewStatusbar;
  QStrList recentFileList; // a list of recently accessed files
	void AddRecentFileToList(char *szFilename);	
	
  /** used for KConfig to store and restore menubar position. Same with
    * tool_bar_pos. If more menubars or toolbars are created, you should add
    * positions as well and implement them in saveOptions() and readOptions().
    */
  KMenuBar::menuPosition menu_bar_pos;
  KToolBar::BarPosition tool_bar_pos;
};   
 
#endif // KFILECODER_H
 
 
 
 
 
 
 
 













































