#include <qpainter.h>

#include "kdisc.h"

KDisc::KDisc (QWidget *parent, const char *name=0) :
  QWidget (parent, name)
{
  
  discposition = QPoint (0, 0);
  setMouseTracking (true);
}

void
KDisc::paintEvent (QPaintEvent *)
{
  QPainter painter (this);

  painter.setPen ( QPen (Qt::black, 3) );
  painter.setBrush ( QBrush (Qt::blue, Qt::Dense4Pattern) );

  painter.drawEllipse (discposition.x(), discposition.y(),
		       25, 25);
}

void
KDisc::mouseMoveEvent (QMouseEvent *qmouseevent)
{

  if (qmouseevent->state()==Qt::LeftButton)
    {
      discposition = qmouseevent->pos();
      update();
    }
  
}

void
KDisc::keyPressEvent (QKeyEvent *qkeyevent)
{

  switch (qkeyevent->key())
    {
    case Qt::Key_Left:
      discposition = QPoint ( discposition.x()-10,
			      discposition.y() );
      update();
      break;
    case Qt::Key_Right:
      discposition = QPoint ( discposition.x()+10,
			      discposition.y() );
      update();
      break;
    case Qt::Key_Up:
      discposition = QPoint ( discposition.x(),
			      discposition.y()-10 );
      update();
      break;
    case Qt::Key_Down:
      discposition = QPoint ( discposition.x(),
			      discposition.y()+10 );
      update();
      break;
    default:
      qkeyevent->ignore();
    }

}
