#include <qbitarray.h>
#include <qdatastream.h>

ASmartWidget::ASmartWidget(const char* name):
  QWidget(name),
  DCOPObject("ASmartWidget") {

    QVBoxLayout *lay = new QVBoxLayout (this, 10, 10);
    l_front = new QLabel("Hello, I'm a smart widget", this);
    lay->addWidget (front);

  }

bool ASmartWidget::setFront(QString& l) {
  // a bit of data processing - eventually filter contents of l
  if (l.find("smart") != -1) {
    l_front->setText( l );
    return true;
  } else
    return false;
}

bool ASmartWidget::process(const QCString &fun,
                           const QByteArray &data,
                           QCString &reply_type,
                           QByteArray &reply_data) {

  if (fun == "setFront(QString)") {
    QDataStream arg(data, IO_ReadOnly);
    QString& atext;
    arg >> atext;
    bool result = setFront(atext);

    QDataStream answer(reply_data, IO_WriteOnly);
    answer << result;
    reply_type = "bool";
    return true;
  } else {
      kdDebug << "Processing DCOP call failed. Function unknown!"
                        << endl;
      return false;
  }
}

