// example_add_test.cc

#include "connect.h"
#include "example_add.h"
#include "artsflow.h"

using namespace Arts;

void main()
{
    // create a MCOP dispatcher (always do this)
    Dispatcher dispatcher;

    Synth_FREQUENCY freq1, freq2;    // some objects
    Synth_WAVE_SIN sin1, sin2;
    Synth_MUL mul;
    Example_ADD add;
    Synth_PLAY play;

    // setup a 440Hz sin and connect it to the add
    setValue(freq1,440.0);
    connect(freq1,sin1);
    connect(sin1,add,"invalue1");

    // setup a 880Hz sin and connect it to the add
    setValue(freq2,880.0);
    connect(freq2,sin2);
    connect(sin2,add,"invalue2");

    // multiply everything with 0.5 (=> no clipping)
    connect(add,"result",mul,"invalue1");
    setValue(mul,"invalue2",0.5);

    // connect the output to the play module
    connect(mul,play,"invalue_left");
    connect(mul,play,"invalue_right");

    // start all modules
    freq1.start(); freq2.start(); sin1.start();
    sin2.start(); mul.start(); add.start(); play.start();

    dispatcher.run();
}
