#include "balance.h"
#include <soundserver.h>
#include <stdio.h>

using namespace Arts;

void fail(char *why) { printf("%s\n",why); exit(1); }

int main(int argc, char **argv)
{
    if(argc != 2) fail("use two arguments");

    Dispatcher dispatcher;
    SimpleSoundServer server(Reference("global:Arts_SimpleSoundServer"));
    if(server.isNull()) fail("can't connect server");

    StereoBalanceControl bcontrol;
	bcontrol = DynamicCast(server.createObject("StereoBalanceControl"));
    if(bcontrol.isNull()) fail("can't castreate object");

    if(strcmp(argv[1],"downmix") == 0)
        bcontrol.balance(sbDownMix);
    if(strcmp(argv[1],"through") == 0)
        bcontrol.balance(sbThrough);
    /* add the others possibilities, if you like */
    bcontrol.start();

    StereoEffectStack effectstack = server.outstack();
    long id=effectstack.insertBottom(bcontrol,"Balance");
    printf("type return to quit\n"); getchar();
    effectstack.remove(id);
    return 0;
}
