#include <stdio.h>

#include <qlabel.h>

#include <kiconloader.h>
#include <kpopupmenu.h>
#include <klocale.h>

#include "kweather.h"

extern "C"
{
    KPanelApplet* init(QWidget *parent, const QString& configFile)
    {
        KGlobal::locale()->insertCatalogue("kweather");
        return new KWeather (configFile, KPanelApplet::Normal,
			     KPanelApplet::Preferences, parent, "kweather");
    }
}       

KWeather::KWeather (const QString& configFile, Type t,
		    int actions, QWidget *parent, const char *name)
  : KPanelApplet (configFile, t, actions, parent, name)
{
  setPalette(QPalette(Qt::gray));
  QLabel *qlabel = new QLabel ("Rainy\n  48F", this);
  qlabel->setAlignment (Qt::AlignVCenter);

  setMinimumSize (qlabel->sizeHint());
  emit updateLayout();
}

void
KWeather::preferences()
{
  printf ("Here we let the user configure the panel applet.\n");
}


