#include "notepad_part.h"
#include <kparts/partmanager.h>
#include <kparts/mainwindow.h>

#include <qsplitter.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qmultilinedit.h>

#include <kapp.h>
#include <kaction.h>
#include <klocale.h>
#include <kstddirs.h>
#include <kdebug.h>

NotepadPart::NotepadPart( QWidget * parent, const char * name )
 : KParts::ReadWritePart( parent, name )
{
  KInstance * instance = new KInstance( "notepadpart" );
  setInstance( instance );

  m_edit = new QMultiLineEdit( parent, "multilineedit" );
  m_edit->setFocus();
  setWidget( m_edit );

  (void)new KAction( i18n( "Select All" ), 0, this, 
        SLOT( slotSelectAll() ), actionCollection(), "selectall" );
  setXMLFile( "notepad_part.rc" );

  setReadWrite( true );
}

void NotepadPart::setReadWrite( bool rw )
{
  m_edit->setReadOnly( !rw );
  if (rw)
    connect( m_edit, SIGNAL( textChanged() ), this, SLOT( setModified() ) );
  else
    disconnect( m_edit, SIGNAL( textChanged() ), this, SLOT( setModified() ) );

  ReadWritePart::setReadWrite( rw ); // always call the parent implementation
}

bool NotepadPart::openFile()
{
  kdDebug() << "NotepadPart: opening " << m_file << endl;
  QFile f(m_file);
  QString s;
  if ( f.open(IO_ReadOnly) ) {
    QTextStream t( &f );
    while ( !t.eof() ) {
      s += t.readLine() + "\n";
    }
    f.close();
  }
  m_edit->setText(s);

  return true;
}

bool NotepadPart::saveFile()
{
  if ( !isReadWrite() )
    return false;
  QFile f(m_file);
  QString s;
  if ( f.open(IO_WriteOnly) ) {
    QTextStream t( &f );
    t << m_edit->text();
    f.close();
    return true ;
  } else
    return false;
}

void NotepadPart::slotSelectAll()
{
  kdDebug() << "NotepadPart::slotSelectAll() called" << endl;
}

#include "notepad_part.moc"
