#include <kiconloader.h>
#include <kstddirs.h>
#include <kapp.h>
#include <kaction.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kdebug.h>
#include <kcmdlineargs.h>
#include <klibloader.h>
#include <qwidget.h>
#include <qdir.h>

#include <kparts/partmanager.h>
#include "ghostviewtest_shell_v2.h"

Shell::Shell()
{
  setXMLFile( "ghostviewtest_shell.rc" );

  KAction * paOpen = new KAction( i18n( "&Open file" ), 0, this, SLOT( slotFileOpen() ), actionCollection(), "file_open" );
  paOpen->setIconSet(QIconSet(BarIcon("fileopen")));

  KAction * paQuit = new KAction( i18n( "&Quit" ), 0, this, SLOT( close() ), actionCollection(), "file_quit" );
  paQuit->setIconSet(QIconSet(BarIcon("exit")));

  m_manager = new KParts::PartManager( this );
  // When the manager says the active part changes,
  // the builder updates (recreates) the GUI
  connect( m_manager, SIGNAL( activePartChanged( KParts::Part * ) ),
           this, SLOT( createGUI( KParts::Part * ) ) );
  m_splitter = new QSplitter( this );

  // Try to find libkghostview
  KLibFactory *factory = KLibLoader::self()->factory( "libkghostview" );
  if (factory)
  {
    // Create the part
    m_gvpart = (KParts::ReadOnlyPart *)factory->create( m_splitter,
                "kgvpart", "KParts::ReadOnlyPart" );
  }
  else
    kdFatal() << "No libkghostview found !" << endl;

  factory = KLibLoader::self()->factory( "libnotepad" );
  if (factory)
    m_notepadpart = (KParts::ReadOnlyPart *)factory->create( m_splitter,
                     "knotepadpart", "KParts::ReadOnlyPart" );
  else
    kdFatal() << "No libnotepad found !" << endl;

  // CHANGE: No longer necessary.
  //setView( m_splitter );
  // Set a reasonable size
  m_splitter->setMinimumSize( 500, 400 );
  m_splitter->show();

  m_manager->addPart( m_gvpart, true ); // sets as the active part
  m_manager->addPart( m_notepadpart, false );
}

Shell::~Shell()
{
  disconnect( m_manager, 0, this, 0 );
}

void Shell::openURL( const KURL & url )
{
  m_gvpart->openURL( url );
  m_notepadpart->openURL( url );
}

//////

void Shell::slotFileOpen()
{
  QString fileName = KFileDialog::getOpenFileName( QString::null, "*.ps|Postscript files (*.ps)", 0L, "file dialog" );
 
  if( !fileName.isEmpty() )
     openURL( KURL( fileName ) );
}

static KCmdLineOptions options[] =
{
 { "+file(s)",          I18N_NOOP("Files to load"), 0 },
 { 0,0,0 }
};
static const char *version = "v0.0.1 2000 (c) David Faure";
static const char *description = I18N_NOOP("This is a test shell for the kghostview part.");

int main( int argc, char **argv )
{
  KCmdLineArgs::init(argc, argv, "ghostviewtest", description, version);
  KCmdLineArgs::addCmdLineOptions( options ); // Add my own options.
  KApplication app;
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  Shell *shell = new Shell;
  if ( args->count() == 1 )
  {
    // Allow full paths, but also simple filenames from current dir
    KURL url( QDir::currentDirPath()+"/", args->arg(0) );
    shell->openURL( url );
  }
  shell->show();
  return app.exec();
}

#include "ghostviewtest_shell_v2.moc"
