#include <qlabel.h>
#include <qmultilineedit.h>

#include <kstdaccel.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kaction.h>

#include "ksimpleapp.moc"

KSimpleApp::KSimpleApp (const char *name) :
  KTMainWindow (name)
{
  KAction *clear = 
    new KAction ("&Clear Text", QIconSet(BarIcon ("filenew")),
		 CTRL+Key_C, this, SLOT (slotClearText()),
		 this);
  KAction *quit =
    new KAction ("&Quit", KStdAccel::quit(), kapp,
		 SLOT (closeAllWindows()), this);

  QPopupMenu *filemenu = new QPopupMenu;
  clear->plug (filemenu);
  filemenu->insertSeparator();
  quit->plug (filemenu);
			
  menuBar()->insertItem ("&File", filemenu);

  clear->plug(toolBar());


  statusBar()->message ("Ready!");

  //Chapter 2, Exercise 2
  editor = new QMultiLineEdit (this);
  setView (editor);
}

void
KSimpleApp::slotClearText ()
{
  //Chapter 2, Exercise 2
  editor->clear();
  statusBar()->message ("Cleared text in content area", 1000);
}


