#include <kapp.h>
#include <kfontdialog.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kmessagebox.h>
#include <kconfig.h>

#include "ksaveacross.moc"


KSaveAcross::KSaveAcross (const char *name)
{
  KStdAction::quit (kapp, SLOT (closeAllWindows()),
		    actionCollection());

  new KAction ("Change Font...", 0, this, SLOT(slotChangeFont()),
	       actionCollection(), "change_font");
  createGUI();

  qlineedit = new QLineEdit (this);

  setView (qlineedit);
}

void
KSaveAcross::slotChangeFont()
{
  QFont qfont = qlineedit->font();

  if (KFontDialog::getFont (qfont))
    qlineedit->setFont(qfont);
}

bool
KSaveAcross::queryClose()
{


  const int yes=0, no=1, cancel=2;
  int yesnocancel;
  
  yesnocancel = 
    KMessageBox::
    questionYesNo (this, "Save changes to document?", "ksaveacross");

  switch (yesnocancel)
    {
    case (yes):
      //We would save the document here and let the application exit.
      return true;
    case (no):
      //Let the application exit without saving the document.
      return true;
    case (cancel):
      //Don't save, but don't let the application exit.
      return false;
    }
}


void
KSaveAcross::saveProperties (KConfig *kconfig)
{
  kconfig->writeEntry ("LineEditorFont", qlineedit->font());
  kconfig->sync();
}

void
KSaveAcross::readProperties (KConfig *kconfig)
{
  qlineedit->setFont (kconfig->readFontEntry ("LineEditorFont"));
}

